#{{uc_id}}.ue-scroll-to {
 {% if position == "fixed" %}
   display:none;
   z-index: 9999;
 {% else %}
   display: flex;
   z-index: auto;
 {% endif %} 
}
#{{uc_id}} .ue-scroll-to-cta {
  cursor: pointer;
  display: flex;
  position: relative;
  transition: all 400ms ease-in-out;
  align-content:center;
  justify-content:center;
  flex-direction:column;
  text-align:center;
}
#{{uc_id}} .ue-scroll-to-cta .ue-scroll-to-icon {
  line-height:1em;
  margin:0 auto;
}

#{{uc_id}} .ue-scroll-to-cta .ue-scroll-to-icon svg {
  height:1em; 
  width:1em; 
}

.ue-scroll-to-cta 
#{{uc_id}} .ue-scroll-to-icon {
  position: relative;
}

#{{uc_id}} .ue-scroll-to-icon:hover {
  cursor: pointer;
}
.ue-snap-v-middle{
  top:50%;
}
.ue-scroll-to-text
{
  font-size:10px;
}

	{% if attention_grabber == 'ue-waggle' %}
	  #{{uc_id}} .ue-scroll-to-cta {
          animation: ue-waggle 5s infinite;
      }

      @keyframes ue-waggle {
          0% {
              transform: none;
          }

          10% {
              transform: rotateZ(-20deg) scale(1.2);
          }

          13% {
              transform: rotateZ(25deg) scale(1.2);
          }

          15% {
              transform: rotateZ(-15deg) scale(1.2);
          }

          17% {
              transform: rotateZ(15deg) scale(1.2);
          }

          20% {
              transform: rotateZ(-12deg) scale(1.2);
          }

          22% {
              transform: rotateZ(0) scale(1.2);
          }

          25%,
          100% {
              transform: rotateZ(0) scale(1);
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-fade' %}
      #{{uc_id}} .ue-scroll-to-cta {
          animation: ue-fade 5s infinite;
      }

      @keyframes ue-fade {
          5% {
              opacity: .25;
          }

          10% {
              opacity: 1;
          }

          15% {
              opacity: .25;
          }

          20%,
          100% {
              opacity: 1;
          }
      }
	{% endif %}
	
	{% if attention_grabber == 'ue-blink' %}
      #{{uc_id}} .ue-scroll-to-cta {
          animation: ue-blink 1.33s ease-out infinite;
      }

      @keyframes ue-blink {
          0% {
              opacity: 1;
          }

          20% {
              opacity: .5;
          }

          100% {
              opacity: 1;
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-grow' %}
      #{{uc_id}} .ue-scroll-to-cta {
          animation: ue-grow .4s ease infinite alternate;
      }

      @keyframes ue-grow {
          0% {
              transform: scale(1);
              border-radius: 50%;
          }

          100% {
              transform: scale(1.1);
              border-radius: 50%;
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-bounce' %}
      #{{uc_id}} .ue-scroll-to-cta {
          animation: ue-bounce 5s infinite cubic-bezier(.84, -.54, .31, 1.19);
      }

      @keyframes ue-bounce {
          0% {
              transform: none;
          }

          10% {
              transform: translateY(-1em);
          }

          100%,
          20% {
              transform: none;
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-spin' %}
      #{{uc_id}} .ue-scroll-to-cta {
          animation: ue-spin 5s infinite cubic-bezier(.56, -.35, .22, 1.5);
      }

      @keyframes ue-spin {
          10% {
              transform: rotateZ(-20deg);
              animation-timing-function: ease;
          }

          100%,
          20% {
              transform: rotateZ(360deg);
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-pulse' %}
      #{{uc_id}} .ue-scroll-to-cta
{
  position:relative;
}
      #{{uc_id}} .ue-scroll-to-cta:after {
          content: "";
          position: absolute;
          top: 0;
          left: 0;
          bottom: 0;
          right: 0;
          border-radius: 50%;
          animation: ue-pulse 2s 1.3s ease-out infinite;
      }

      #{{uc_id}} .ue-scroll-to-cta:before {
          content: "";
          position: absolute;
          top: 0;
          left: 0;
          bottom: 0;
          right: 0;
          border-radius: 50%;
          animation: ue-pulse 2s .8s ease-out infinite;
      }

      @keyframes ue-pulse {
          0% {
              transform: scale(1);
              box-shadow: 0 0 2px {{pulse_color}}, inset 0 0 1px {{pulse_color}};
          }

          95% {
              box-shadow: 0 0 50px transparent, inset 0 0 30px transparent;
          }

          100% {
              transform: scale(2.25);
          }
      }
	{% endif %}

	{% if attention_grabber == 'ue-shine' %}
	  
      #{{uc_id}} .ue-scroll-to-cta {
          position: relative;
          overflow: hidden;
      }
      #{{uc_id}} .ue-scroll-to-cta:after {
          animation: ue-shine 5s infinite;
          content: '';
          position: absolute;
          top: 0;
          right: 0;
          bottom: 0;
          left: 0;
          background: linear-gradient(to bottom, transparent, rgba(255, 255, 255, .2) 50%, transparent);
          transform: rotateZ(60deg) translate(0, 5em);
      }

      @keyframes ue-shine {
          20%,
          100% {
              transform: rotateZ(60deg) translate(0, -80px);
          }
      }
    {% endif %}