{{ ucfunc("put_docready_start") }}		
	
	var checkedClass = "ue-checkbox-checked";
  	var itemSelector = ".ue-checkbox-field-item";
    var itemInputSelector = ".ue-checkbox-field-item-input";
	var mainInputSelector = ".ue-checkbox-field-input";

	var objWidget = jQuery("#{{uc_id}}");
  	var objItems = objWidget.find(itemSelector);  	
  	var objInputs = objWidget.find(itemInputSelector);
  	var g_objMainInput = objWidget.find(mainInputSelector);
  	
	var g_mainValue = 0;
	var g_mainArray = [];
	var g_dataCheckboxMode = g_objMainInput.data("checkbox-mode");

	/**
    * update main input
    */
	function updateMainInputValue(value){     
      
        {% if checkbox_value_handling == "num" or checkbox_value_handling == "text" %}
          value = value.map(item => item.trim()).join(', ');
        {% endif %}
 
    	g_objMainInput.attr('value', value);       
    }

	/**
    * adds to main value
    */
	function appendMainValue(objInput, optionVal){    
 		if(g_dataCheckboxMode == "sum"){
            
          optionVal = Number(optionVal);
          
          //sum main value and item value
          g_mainValue = g_mainValue + optionVal;
            
          //set value to main input
          updateMainInputValue(g_mainValue);           
        }else{
                      
          //add to main array checked value
          g_mainArray.push(optionVal);
                     
          //set value to main input
          updateMainInputValue(g_mainArray);
        }
    }

	/**
    * substracts from main value
    */
	function substractMainValue(objInput, optionVal){    
    	if(g_dataCheckboxMode == "sum"){
            
           optionVal = Number(optionVal);
         
           //minus item value from main value
    	   g_mainValue = g_mainValue - optionVal;
            
           //set value to main input
           updateMainInputValue(g_mainValue);        
        }else{
                
            var checkedIndex = g_mainArray.indexOf(optionVal);
           	var isValueExist = checkedIndex > -1;
            
            //remove from array unchecked value
            if(isValueExist == true)
            g_mainArray.splice(checkedIndex, 1);
            
            //set value to main input
          	updateMainInputValue(g_mainArray);
        }
    }
  
	/**
    * set checked state
    */
  	function setChecked(objInput){
    		
      var optionVal = objInput.val().trim();
      var objSelectedItem = objInput.parents(itemSelector);
      var isChecked = objSelectedItem.hasClass(checkedClass);
            
      if(isChecked == false){
               
          //set checked attr
          objInput[0].setAttribute("checked", "");      
          appendMainValue(objInput, optionVal);        
      }else{
      
          //remove checked attr
          objInput.removeAttr("checked");         
          substractMainValue(objInput, optionVal);
      }      
      
      //trigger input event
      g_objMainInput.trigger("input");      
    }
  
	/**
    * set input change behaviour
    */
  	function onInputChange(){    
      var objInput = jQuery(this);
     
      setChecked(objInput);      
    }
  
	/**
    * set item input change behaviour
    */
  	function onItemsInputChange(){
    
   	  var objSelectedInput = jQuery(this);             
      var objSelectedItem = objSelectedInput.parents(itemSelector);
      var isActive = objSelectedItem.hasClass(checkedClass); 
     
      if(isActive == true)
      objSelectedItem.removeClass(checkedClass);
      else
      objSelectedItem.addClass(checkedClass);
    }  	 

	/**
    * init
    */
	function initCheckboxField(){
    
      //init events
      objInputs.on("input", onInputChange);  	

      // Add ue-radio-checked class to parent item
      objInputs.on('change', onItemsInputChange); 
    }

	//run checkbox field
	initCheckboxField();

	//after filters change
	objWidget.on("uc_ajax_refreshed",function(){      
          
      objItems = objWidget.find(itemSelector);
      objInputs = objWidget.find(itemInputSelector);
      g_mainArray = [];
      
      g_objMainInput.attr('value', g_mainArray);
      
      initCheckboxField();      
    });

	//start conditions	
	var strJsonVisibility = {{put_attributes_json(null,"visibility")}};
    var arrVisibility = JSON.parse(strJsonVisibility);
	var checkUEForms = setInterval(setFieldVisibility, 2000);

	function setFieldVisibility(){     
      if(typeof g_ucUnlimitedForms !== undefined){

        g_ucUnlimitedForms.setVisibility(arrVisibility, "{{uc_id}}");   

        clearInterval(checkUEForms);
      }      
    }

  	//init events
    var objAllInputFields = jQuery(".ue-input-field");
    var objAllOptionFields = jQuery(".ue-option-field");

    objAllInputFields.on('input', setFieldVisibility);    
    objAllOptionFields.on('change', setFieldVisibility);
	
    objAllInputFields.on('input_calc', setFieldVisibility);
	objAllOptionFields.on('input_calc', setFieldVisibility);
	//end conditions

{{ ucfunc("put_docready_end") }}