{% set itemValue %}
	{% if checkbox_value_handling == "sum" %}{{item.item_value_sum}}{% endif %}
	{% if checkbox_value_handling == "num" %}{{item.item_value_num}}{% endif %}
	{% if checkbox_value_handling == "text" and use_item_titles_as_value == "false" %}{{item.item_value_text|raw}}{% elseif checkbox_value_handling == "text" and use_item_titles_as_value == "true" %}{{item.title|raw}}{% endif %}
{% endset %}

{% set checkboxItem  %}
	<input id="{{item.item_id}}" class="ue-checkbox-field-item-input" type="checkbox" value="{{itemValue}}" >
{% endset %}

{% set itemLink %}
	{% if item.show_link == "true" %}<a class="ue-checkbox-field-item-link" href="{{item.item_link}}" {{item.item_link_html_attributes|raw}}>{{item.item_link_text|raw}}</a>{% endif %}
{% endset %}

<span class="ue-checkbox-field-item {{item.item_repeater_class}}">

  {{checkboxItem}}

  <label class="ue-checkbox-field-item-label" for="{{item.item_id}}">
    <span class="ue-checkbox-field-item-label-container">{% if checkbox_icon_type == "custom" %}<span class="ue-checkbox-field-item-label-container-icon">{{checkbox_icon_html|raw}}</span>{% endif %}</span>
    
     {% if (display_format == "simple") or (display_format == "buttons") %}{{item.title|raw}}{{itemLink}}{% endif %}
    
     {% if display_format == "image" %}
       <img src="{{item.checkbox_image}}" alt="{{item.checkbox_image_alt}}" title="{{item.checkbox_image_title}}" {{item.checkbox_image_attributes|raw}}>
       <span class="ue-checkbox-field-item-image-title">{{item.title|raw}}{{itemLink}}</span>
     {% endif %}           
    
  </label>

</span>