#{{uc_id}}.ucform-has-conditions{
	display: none;
}
{% if rtl == "true" %}
#{{uc_id}} *{
  direction: rtl;
}
{% endif %}

{% if uc_inside_editor == "yes" %}
  #{{uc_id}}.ucform-has-conditions{
      display: block;
  }
{% endif %}

{% if show_label == "true" %}
  #{{uc_id}}.ue-checkbox-field{
    display:flex;
  }
{% endif %}

{% if show_description == "true" %}
#{{uc_id}} .ue-checkbox-desc-wrapper{	
  display:flex;
}
{% endif %}

#{{uc_id}} .ue-checkbox-field-input{
  opacity: 0;
  pointer-events: none;
  position: absolute;
}

#{{uc_id}} .ue-checkbox-field-item{
  display: flex;
  position: relative;
}

#{{uc_id}} .ue-checkbox-field-item-label{
  cursor: pointer;
}

#{{uc_id}} .ue-checkbox-field-item-label-container{
  display: inline-flex;
  align-items: center;
  position: relative;
}

#{{uc_id}} .ue-checkbox-field-form{
  display: flex;
  {% if allow_line_breaks == "true" %}
  flex-wrap: wrap;
  {% endif %}
}

{% if display_format == "simple" %}

  #{{uc_id}} .ue-checkbox-field-item-label {
    display: flex;
    position: relative;
    transition-duration: 300ms;
  }

  #{{uc_id}} .ue-checkbox-field-item-input {
    position: absolute;
    left: 0;
    -webkit-appearance: none;
    {% if checkbox_vertical_align == "start" %}
    top: 0;
    {% elseif checkbox_vertical_align == "center" %}
	top: 50%;
    transform: translate(0, -50%);
    {% elseif checkbox_vertical_align == "end" %}
	bottom: 0;
    {% endif %}
  }

  #{{uc_id}} .ue-checkbox-field-item-input + .ue-checkbox-field-item-label {
    position: relative;
    cursor: pointer;
    padding: 0;
  }

  #{{uc_id}} .ue-checkbox-field-item-input + .ue-checkbox-field-item-label .ue-checkbox-field-item-label-container:before {
    content: "";
    display: inline-block;
    vertical-align: text-top;
    transition-duration: 300ms;
    cursor: pointer;
    flex: 0 0 auto;
  }

  #{{uc_id}} .ue-checkbox-field-item-input:checked + .ue-checkbox-field-item-label .ue-checkbox-field-item-label-container:after {
    content: "";
    position: absolute;
    transition-duration: 300ms;
    {% if checkbox_icon_type == "def" %}
    width: 2px;
    height: 2px;
    transform: rotate(45deg);
    background: {{check_color}};
    box-shadow: 2px 0 0 {{check_color}}, 4px 0 0 {{check_color}}, 4px -2px 0 {{check_color}}, 4px -4px 0 {{check_color}}, 4px -6px 0 {{check_color}}, 4px -8px 0 {{check_color}};
    {% elseif checkbox_icon_type == "custom" %}
    display: none;
    {% endif %}
  }

  #{{uc_id}} .ue-checkbox-field-item-label-container-icon{
	display: none;
  }

  #{{uc_id}} .ue-checkbox-field-item-input:checked + .ue-checkbox-field-item-label .ue-checkbox-field-item-label-container-icon{
	display: block;
    position: absolute;
    transition-duration: 300ms; 
    fill: {{check_color}};
    color: {{check_color}};
  }
{% endif %}

{% if display_format == "image" %}
  #{{uc_id}} .ue-checkbox-field-form{
    display:grid;
  }
  #{{uc_id}} .ue-checkbox-field-item-input{
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    -webkit-appearance: none;
    background-color: unset;
  }
  #{{uc_id}} .ue-checkbox-field-item-label{
    display: flex;
    flex-direction:column;
    overflow:hidden;
  }
  #{{uc_id}} .ue-checkbox-field-item-image-title{
    display:block;
    width:100%;
  }
  #{{uc_id}} .ue-checkbox-field-item-label{
    width:100%;
  }
  #{{uc_id}} .ue-checkbox-field-item-label img{
    width:100%;
  }
  #{{uc_id}} .ue-checkbox-desc-wrapper{
    width:100%;
  }
{% endif %}

{% if display_format == "buttons" %}

  #{{uc_id}} .ue-checkbox-field-item-input{
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    -webkit-appearance: none;
  }
{% endif %}
 
#{{uc_id}} .ue-checkbox-field-title{
  display: flex;
  flex-shrink: 0;
  align-items: center;
  flex-grow: 1;
}

#{{uc_id}} label{
  line-height: inherit;
}  

#{{uc_id}} .ue-checkbox-field-required{
  line-height: 1;
}