#{{uc_id}}{
	position: relative;
    {% if direction == "true" %}
    direction: rtl;
    {% else %}
    direction: ltr;
    {% endif %}
}

#{{uc_id}} .owl-stage{
  display: block;
}

#{{uc_id}} .ue-multi-step-form-template-holder{
	display: none;
}

#{{uc_id}} .uc-message{
	display: none;
}

#{{uc_id}} .ue-multi-step-form-item{
  	transition: all .3s;
    margin: 0 1px;
}

#{{uc_id}} .ue-multi-step-form-item.uc-active{
	position: static;
  	opacity: 1;
  	pointer-events: all;
}

#{{uc_id}} .ue-multi-step-form-button-submit{
	display: none;
    align-items: center;
	justify-content: center;
}

#{{uc_id}} .ue-multi-step-form-button-submit.ue-success{
  display: none !important;
}

#{{uc_id}} .ue-multi-step-form-button-prev{
	display: none;
}

#{{uc_id}} .ue-multi-step-form-buttons{
	display: flex;
}
{% if justify_buttons == "space-between" %}
#{{uc_id}} .ue-multi-step-form-buttons.ue_first_step{
   justify-content: end;
}
{% endif %}

#{{uc_id}} .ue-multi-step-form-button-holder{
  /* flex: 1; */
}

#{{uc_id}} .ue-multi-step-form-button-holder.ue_center_btn_holder{
  display: flex;
  justify-content: center;
}

{% if (hide_sections_in_editor == "message") and (uc_inside_editor == "yes")  %}
  #{{uc_id}} .uc-message{
      display: block;
  }
{% endif %}


{% if uc_inside_editor == "yes" and show_template_sections == "true" %}
  #{{uc_id}} .ue-multi-step-form-template-holder{
  	display: block;
  } 
{% endif %}

/* align item content horizontally accordingly to indicator */
#{{uc_id}} .ue-step-item-content{
  display: flex;
  align-items: center;
}

#{{uc_id}} .ue-step-item-content .ue-step-item-line{
  opacity: 0;
}
/* end align item content horizontally accordingly to indicator */

#{{uc_id}} .ue-step-item:first-child .ue-step-item-line:first-child{
  display: none;
}

#{{uc_id}} .ue-step-item:first-child .ue-step-item-gap:nth-child(2){
  display: none;
}

#{{uc_id}} .ue-step-item:last-child .ue-step-item-line:last-child{
  display: none;
}

#{{uc_id}} .ue-step-item:last-child .ue-step-item-gap:nth-last-child(2){
  display: none;
}

/* loader styles */
#{{uc_id}} .ue-submit-button-loader {
	display: none;
	align-items: center;
	justify-content: center;
}

#{{uc_id}} .ue-submit-button-loader.ue-loading {
	display: flex;
}
/* end loader styles */

/* indicator styles */
{% if show_indicator == "true" %}

  #{{uc_id}} .ue-multi-step-form-indicator-wrapper{
	display: flex;
  }

  #{{uc_id}} .ue-multi-step-form-indicator-container{
      display: flex;
      width: 100%;
  }

  #{{uc_id}} .ue-link{
    display:block;
    position:absolute;
    top:0px;
    bottom:0px;
    left:0px;
    right:0px;
  }

  #{{uc_id}} .ue-step-item  {
    flex:1;
    display:flex;
    flex-direction:column;
    position:relative;
  }

  #{{uc_id}} .ue-item-highlight{
    display: flex;
    align-items:center;
  }

  #{{uc_id}} .ue-step-item-gap{
    flex-grow:0;
    flex-shrink:0;
  }

  #{{uc_id}} .ue-step-item-line{
    height:{{line_width}}px;
    flex-grow:1;
  }

  #{{uc_id}} .ue-step-icon{
    display:flex;
    justify-content:center;
    align-items:center;
    flex-grow:0;
    flex-shrink:0;
    position:relative;
    line-height:1em;
    transition:0.3s;
  }

  #{{uc_id}} .ue-icon svg{
    height:1em;
    width:1em;
  }

  #{{uc_id}} .ue-step-label{
    position:absolute;
    {{label_x_position}}:{{x_space}}px;
    {{label_y_position}}:{{y_space}}px;
    display:flex;
    justify-content:center;
    align-items:center;
  }

  .ue-step-label{
    font-size:9px;
    line-height:1em;
  }

  #{{uc_id}} .ue-step-item-spacer{
    flex-grow:0;
    flex-shrink:0;
  }

  #{{uc_id}} .ue-done-icon{
    display: none;
    {% if debug_done_icon == "true" %}
    display: flex !important;
    {% endif %}
  }

  #{{uc_id}} .ue-done-icon.ue-visible{
    display: flex;
  }

  #{{uc_id}} .ue-step-icon-item.ue-invisible{
	display: none;
  }

  #{{uc_id}} .ue-step-icon-item{
	{% if debug_done_icon == "true" %}
    display: none !important;
    {% endif %}
  }

  /* progress bar styles */
  #{{uc_id}} .ue-multi-step-form-indicator-progress-bar-wrapper{
	display: flex;
  }
 
  #{{uc_id}} .ue-multi-step-form-indicator-progress-bar-container{
	width: 100%;
  }

  #{{uc_id}} .ue-multi-step-form-indicator-progress-bar-content{
    display: flex;
    justify-content: space-between;
  }

  #{{uc_id}} .ue-multi-step-form-indicator-progress-bar-content-item{
    display: flex;
    align-items: center;
  }

  #{{uc_id}} .ue-multi-step-form-indicator-progress-bar{
    overflow: hidden;
  }

  #{{uc_id}} .ue-multi-step-form-indicator-progress-bar-inner{
    height: 100%;
    width: 0;
    transition: all .3s ease-out;
  }
  /* end progress bar styles */

  {% if layout == "vertical" %}

    #{{uc_id}} .ue-multi-step-form-indicator-container{
      flex-direction:column;
    }

    #{{uc_id}} .ue-step-item{
      flex-direction: row;
    }

    #{{uc_id}} .ue-item-highlight{
      flex-direction: column;
    }

    #{{uc_id}} .ue-step-item .ue-step-item-line:first-child{
      display: none;
    }

    #{{uc_id}}  .ue-step-item-gap:nth-child(2){
      display: none;    
    }

    #{{uc_id}}  .ue-step-item-line:first-child{
        display: none;    
    }

    #{{uc_id}}  .ue-step-item-line{
       height:100%;
       width:{{line_width}}px;
    }

  {% endif %}

  {% if layout == "hv" %}

    @media only screen and (max-width: {{responsive_breakpoint}}px) {
      
      #{{uc_id}} .ue-multi-step-form-indicator-container{
          flex-direction:column;
        }

      #{{uc_id}} .ue-step-item{
        flex-direction:row;
      }

      #{{uc_id}} .ue-item-highlight{
        flex-direction:column;
      }

      #{{uc_id}} .ue-step-item .ue-step-item-line:first-child{
        display:none;
      }
      
      #{{uc_id}}  .ue-step-item-gap:nth-child(2){
        display:none;    
      }
      
      #{{uc_id}}  .ue-step-item-line:first-child{
        display:none;    
      }

      #{{uc_id}}  .ue-step-item-line{
        height:100%;
        width:{{line_width}}px;
      }
    }

  {% endif %}

{% endif %}
/* end indicator styles */