{{ ucfunc("put_docready_start") }}
		
	var objWrapper = jQuery("#{{uc_id}}");
	var objItems = objWrapper.find(".ue_hotspot-item");
	var objOverlay = objWrapper.find(".ue-popup-overlay");
	var objCloseButtons = objWrapper.find(".item-popup-close");
	var objDocument = jQuery(document);
	var popupSelector = ".item-popup";
	var classOpened = "ue-opened";

	/**
    * on body mouse up
    */
	function onBodyMouseUp(e){
    
    	var dataCloseOnBodyClick = objWrapper.data("close-on-body-click");
      
      	if(dataCloseOnBodyClick == false)
        return(true);
      
      	var objPopupOpened = jQuery(popupSelector+"."+classOpened);
      
        if (!objPopupOpened.is(e.target) && !objPopupOpened.is(e.target) && objPopupOpened.has(e.target).length === 0) {
            objOverlay.hide();
            objPopupOpened.hide();
          
          	objPopupOpened.removeClass(classOpened);
        }
    }

	/**
    * on close button click
    */
	function onCloseButtonClick(){
    
      	var objButton = jQuery(this);
      	var objPopup = objButton.parents(popupSelector);
      
    	//hide overlay with items2
      	objOverlay.hide();
      
      	//hide opened popup
      	objPopup.hide();
      
      	objPopup.removeClass(classOpened);
    }

	/**
    * click on spots
    */
	function onItemClick(){
    
    	var objItem = jQuery(this);
      	var itemId = objItem.attr("id");
      	var objRelatedPopup = jQuery("#popup"+itemId);
      
      	//show overlay with items2
      	objOverlay.show();
      
      	//show related popup
      	objRelatedPopup.show();
      	
      	objRelatedPopup.addClass(classOpened);
    }
	
	//init events
	objItems.on("click", onItemClick);
	objCloseButtons.on("click", onCloseButtonClick);
    objDocument.on("mouseup", onBodyMouseUp);
  
  //Tooltip Start
  {% if show_tooltip == "true" and always_show_tooltip == "false" %}
    jQuery('#{{uc_id}} .spot').tooltipster({
      trigger: '{{trigger}}',
      contentAsHTML: true,
      maxWidth:{{tooltip_max_width_nounit}},
      parent: jQuery('#{{uc_id}}'),
      functionPosition: function (instance, helper, position) {
        const containerOffset = jQuery('#{{uc_id}}').offset();

        // Subtract container's position to localize the tooltip
        position.coord.top -= containerOffset.top;
        position.coord.left -= containerOffset.left;

        return position;
      }
    });
  {% endif %}
  {% if show_tooltip == "true" and always_show_tooltip == "true" %}
    jQuery('#{{uc_id}} .spot').tooltipster({
      trigger: 'custom',
      triggerOpen: {
        click: true,
        touchstart: true,
      },
      triggerClose: {
        click: false,
        mouseleave: false
      },
      contentAsHTML: true,
      maxWidth:{{tooltip_max_width_nounit}},
      parent: jQuery('#{{uc_id}}'),
      functionPosition: function (instance, helper, position) {
        const containerOffset = jQuery('#{{uc_id}}').offset();

        // Subtract container's position to localize the tooltip
        position.coord.top -= containerOffset.top;
        position.coord.left -= containerOffset.left;

        return position;
      }
    });
    jQuery('#{{uc_id}} .spot').tooltipster('open');
  {% endif %}
  //Tooltip end
  
  	var objRemoteOptions = {
    	class_items:"spot",
    	class_active:"uc-active",
      	add_set_active_code:true,
      	active_code_first_unselected:true
    };
      
  	{{ucfunc("put_remote_parent_js","objWrapper","objRemoteOptions")}}  
    	
{{ ucfunc("put_docready_end") }}