<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Bravis-Themes
 */
$post_tag = immigway()->get_theme_opt( 'post_tag', true );
$post_navigation = immigway()->get_theme_opt( 'post_navigation', false );
$post_author_info = immigway()->get_theme_opt( 'post_author_info', false );
$post_social_share = immigway()->get_theme_opt( 'post_social_share', false );
$tags_list = get_the_tag_list();
$post_date = immigway()->get_theme_opt( 'post_date', true );
$pxl_post_title = immigway()->get_theme_opt('pxl_post_title','default');
$pxl_post_title_text  = immigway()->get_theme_opt('pxl_post_title_text',esc_html__('Single Blog', 'immigway'));
?>
<article id="pxl-post-<?php the_ID(); ?>" <?php post_class('pxl---post'); ?>>
    <?php if (has_post_thumbnail()) {
        echo '<div class="pxl-item--image">'; ?>
        <?php the_post_thumbnail('immigway-large'); ?>
        <?php echo '</div>';
    }?>
    <div class="pxl-item--holder">
        <?php if($post_date) : ?>
            <span class="pxl-item--date"><?php echo get_the_date(); ?></span>
        <?php endif; ?>
        <?php if($pxl_post_title == 'custom') : ?>        
            <h2 class="pxl-item-title"><?php echo esc_attr(get_the_title($post->ID)); ?></h2>
        <?php endif; ?>
        <div class="pxl-item--content clearfix">
            <?php
            the_content();
            wp_link_pages( array(
                'before'      => '<div class="page-links">',
                'after'       => '</div>',
                'link_before' => '<span>',
                'link_after'  => '</span>',
            ) );
            ?>
        </div>

    </div>

    <?php if($post_tag && $tags_list || $post_social_share ) :  ?>
        <div class="pxl--post-footer">
            <?php if($post_tag) { immigway()->blog->get_tagged_in(); } ?>
            <?php if($post_social_share) { immigway()->blog->get_socials_share(); } ?>
        </div>
    <?php endif; ?>

    <?php if($post_author_info) { immigway()->blog->get_post_author_info(); } ?>

    <?php if($post_navigation) { immigway()->blog->get_post_nav(); } ?>
</article><!-- #post -->