<?php
/**
 * @package Bravis-Themes
 */
$visa_icon_font = get_post_meta(get_the_ID(), 'visa_icon_font', true);
$visa_excerpt = get_post_meta(get_the_ID(), 'visa_excerpt', true);
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('col-lg-4 col-md-6 col-sm-12'); ?>>
    <div class="pxl-item--inner">
        <div class="pxl-item--main">
            <?php if (has_post_thumbnail()) {
                $img_url = get_the_post_thumbnail_url(get_the_ID(), 'immigway-portfolio');
                echo '<div class="pxl-item--featured bg-image" style="background-image: url('. esc_url($img_url).');">'; ?>
                    <div class="pxl-item--shape2 pxl-item--shape-secondary">
                        <div class="pxl-shape--divider pxl-shape--divider1"></div>
                        <div class="pxl-shape--divider pxl-shape--divider2"></div>
                        <div class="pxl-shape--divider pxl-shape--divider3"></div>
                    </div>
                <?php echo '</div>';
            } ?>
            <div class="pxl-item--holder">
                <?php if(!empty($visa_icon_font)) : ?>
                    <div class="pxl-item--icon">
                        <i class="<?php echo esc_attr($visa_icon_font); ?>"></i>
                    </div>
                <?php endif; ?>
                <h3 class="pxl-item--title"><a href="<?php echo esc_url( get_permalink()); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h3>
                <div class="pxl-item--content">
                    <?php echo wp_trim_words( $visa_excerpt, 30, $more = null ); ?>
                </div>
                <div class="pxl-item--readmore">
                    <a class="btn--readmore2" href="<?php echo esc_url( get_permalink()); ?>">
                        <span class="btn-readmore--icon pxl-mr-10"><i class="flaticon-right-arrow-2 rtl-reverse"></i></span>
                        <span class="btn-readmore--text">
                            <?php echo esc_html__('Read more', 'immigway'); ?>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</article>