<?php
// Register Video Player Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_video_player',
        'title' => esc_html__('BR Video Player', 'immigway' ),
        'icon' => 'eicon-play',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'tilt'
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'video_style',
                            'label' => esc_html__('Custom Style', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => 'Default',
                                'vd-testimonial' => 'Testimonial',
                            ],
                            'default' => '',
                        ),
                        array(
                            'name' => 'testimonial_desc',
                            'label' => esc_html__('Description', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => 'I am extremely grateful to Immigway Visa Consultancy for making my dream true. The helped me process my visa for Canada. It has accepted in record time. Immigway are amazing so I Highly recommend them.',
                            'condition' => [
                                'video_style' => ['vd-testimonial'],
                            ]
                        ),
                        array(
                            'name' => 'testimonial_client',
                            'label' => esc_html__('Client', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => 'Wesley Jonathon',
                            'condition' => [
                                'video_style' => ['vd-testimonial'],
                            ]
                        ),
                        array(
                            'name' => 'testimonial_position',
                            'label' => esc_html__('Position', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => 'Student, Vancouver Island University',
                            'condition' => [
                                'video_style' => ['vd-testimonial'],
                            ]
                        ),
                        array(
                            'name' => 'video_image_client',
                            'label' => esc_html__('Custom Image Client', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => 'No',
                                'vd-image-client' => 'Yes',
                            ],
                            'default' => '',
                        ),
                        array(
                            'name' => 'image_client',
                            'label' => esc_html__('Image Client', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'video_image_client' => ['vd-image-client'],
                            ],
                        ),
                        array(
                            'name' => 'img_client_size',
                            'label' => esc_html__('Image Size', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size - Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme. Alternatively enter size in pixels Example: 200x100 - Width x Height.',
                            'condition' => [
                                'video_image_client' => ['vd-image-client'],
                            ],
                        ),
                        array(
                            'name' => 't_width',
                            'label' => esc_html__('Image Client Max Width', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video-image-client img' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'video_image_client' => ['vd-image-client'],
                            ],
                        ),
                        array(
                            'name' => 'video_link',
                            'label' => esc_html__('Link', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => 'https://www.youtube.com/watch?v=SF4aHwxHtZ0',
                        ),
                        array(
                            'name' => 'video_icon',
                            'label' => esc_html__('Video Icon', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::ICONS,
                            'fa4compatibility' => 'icon',
                        ),
                        array(
                            'name' => 'image_type',
                            'label' => esc_html__('Image Type', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'none' => 'None',
                                'img' => 'Image',
                                'bg' => 'Background',
                            ],
                            'default' => 'none',
                        ),
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Image', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                            'condition' => [
                                'image_type' => ['img', 'bg'],
                            ],
                        ),
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size - Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme. Alternatively enter size in pixels Example: 200x100 - Width x Height.',
                            'condition' => [
                                'image_type' => 'img',
                            ],
                        ),
                        array(
                            'name' => 'image_height',
                            'label' => esc_html__('Image Height', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'description' => esc_html__('Enter number.', 'immigway' ),
                            'condition' => [
                                'image_type' => 'bg',
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'control_type' => 'responsive',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video--imagebg' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'btn_video_style',
                            'label' => esc_html__('Button Video Style', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style1' => 'Style 1',
                                'style2' => 'Style 2',
                                'style3' => 'Style 3',
                                'style4' => 'Style 4',
                                'style5' => 'Style 5',
                                'style6' => 'Style 6',
                                'style7' => 'Style 7',
                                'style8' => 'Style 8',
                            ],
                            'default' => 'style1',
                        ),
                        array(
                            'name' => 'btn_text',
                            'label' => esc_html__('Button Text', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'label_block' => true,
                            'condition' => [
                                'btn_video_style' => ['style2','style3','style5','style6','style7'],
                            ],
                        ),
                        array(
                            'name' => 'btn_video_position',
                            'label' => esc_html__('Button Video Position', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'p-center' => 'Center',
                                'p-top-left' => 'Top Left',
                                'p-top-right' => 'Top Right',
                                'p-bottom-left' => 'Bottom Left',
                                'p-bottom-right' => 'Bottom Right',
                            ],
                            'default' => 'p-center',
                            'condition' => [
                                'image_type' => ['img','bg'],
                            ],
                        ),
                        array(
                            'name' => 'top_positioon',
                            'label' => esc_html__('Top Position', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'control_type' => 'responsive',
                            'default' => [
                                'size' => 0,
                                'unit' => '%',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right' => 'top: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_video_position' => ['p-top-left', 'p-top-right'],
                            ],
                        ),
                        array(
                            'name' => 'right_positioon',
                            'label' => esc_html__('Right Position', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'control_type' => 'responsive',
                            'default' => [
                                'size' => 0,
                                'unit' => '%',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right' => 'right: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_video_position' => ['p-top-right', 'p-bottom-right'],
                            ],
                        ),
                        array(
                            'name' => 'bottom_positioon',
                            'label' => esc_html__('Bottom Position', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'control_type' => 'responsive',
                            'default' => [
                                'size' => 0,
                                'unit' => '%',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right' => 'bottom: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_video_position' => ['p-bottom-left', 'p-bottom-right'],
                            ],
                        ),
                        array(
                            'name' => 'left_positioon',
                            'label' => esc_html__('Left Position', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px', '%' ],
                            'control_type' => 'responsive',
                            'default' => [
                                'size' => 0,
                                'unit' => '%',
                            ],
                            'range' => [
                                '%' => [
                                    'min' => 0,
                                    'max' => 100,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left' => 'left: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'btn_video_position' => ['p-top-left', 'p-bottom-left'],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Style', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array_merge(
                        array(
                            array(
                                'name' => 'button_width',
                                'label' => esc_html__('Button Width', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px'],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 300,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .btn-video' => 'min-width: {{SIZE}}{{UNIT}}; width:{{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'icon_size',
                                'label' => esc_html__('Icon Font Size', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px'],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 300,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .btn-video i' => 'font-size: {{SIZE}}{{UNIT}}; ',
                                ],
                            ),
                            array(
                                'name' => 'btn_box_color',
                                'label' => esc_html__('Button Box Color', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .pxl-video--inner .btn-video, {{WRAPPER}} .pxl-video-player .pxl-video--inner .btn-video:before' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'bgr_box_color',
                                'label' => esc_html__('Background Box Color', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .pxl-video--inner .btn-video:after' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'btn_icon_color',
                                'label' => esc_html__('Button Icon Color', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .pxl-video--inner .btn-video' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'btn_third_color',
                                'label' => esc_html__('Button Text Color', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player .pxl-label' => 'color: {{VALUE}};',
                                ],
                                'condition' => [
                                    'btn_video_style' => ['style2','style3','style5','style6','style7'],
                                ],
                            ),
                            array(
                                'name' => 'btn_text_typography',
                                'label' => esc_html__('Button Text Typography', 'immigway' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .pxl-video-player .pxl-label',
                                'condition' => [
                                    'btn_video_style' => ['style2','style3','style5','style6','style7'],
                                ],
                            ),
                            array(
                                'name' => 'img_border_radius',
                                'label' => esc_html__('Box Border Radius', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .pxl-video-player1 .pxl-video--holder img, {{WRAPPER}} .pxl-video-player1 .pxl-video--holder .pxl-video--imagebg' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'condition' => [
                                    'image_type' => ['img', 'bg'],
                                ],
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'section_style_testimonial',
                    'label' => esc_html__( 'Testimonial', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'video_style' => ['vd-testimonial'],
                    ],
                    'controls' => array(
                         array(
                            'name' => 'test_width',
                            'label' => esc_html__('Testimonial Max Width', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px', '%' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap' => 'max-width: {{SIZE}}{{UNIT}};',
                            ],
                            
                        ),
                        array(
                            'name' => 'test_padding',
                            'label' => esc_html__('Testimonial Padding', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrapn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                        ),
                        array(
                            'name' => 'test_bgr_color',
                            'label' => esc_html__( 'Background Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap' => 'background-color: {{VALUE}};',
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'test_desc_color',
                            'label' => esc_html__( 'Description Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap .pxl-video-testimonial-desc' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'test_desc_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'label' => esc_html__( 'Description Typography', 'immigway' ),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap .pxl-video-testimonial-desc',
                        ),
                        array(
                            'name' => 'desc_margin',
                            'label' => esc_html__('Description Margin', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap .pxl-video-testimonial-desc' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'client_name_color',
                            'label' => esc_html__( 'Client Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap .pxl-video-testimonial-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'client_name_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'label' => esc_html__( 'Client Typography', 'immigway' ),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap .pxl-video-testimonial-title',
                        ),
                        array(
                            'name' => 'client_margin',
                            'label' => esc_html__('Client Margin', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap .pxl-video-testimonial-title' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'control_type' => 'responsive',
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'position_color',
                            'label' => esc_html__( 'Client Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap .pxl-video-testimonial-postion' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'position_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'label' => esc_html__( 'Client Typography', 'immigway' ),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-video-player .pxl-video-testimonial-wrap .pxl-video-testimonial-postion',
                        ),
                    ),
                ),
                immigway_widget_animation_settings(),
            ),
        ),
    ),
    immigway_get_class_widget_path()
);