<?php
$pt_supports = ['post','case_studies','service','visa','country'];
pxl_add_custom_widget(
    array(
        'name' => 'pxl_post_carousel',
        'title' => esc_html__('BR Post Carousel', 'immigway' ),
        'icon' => 'eicon-posts-carousel',
        'categories' => array('pxltheme-core'),
        'scripts' => array(
            'swiper',
            'pxl-swiper',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name'     => 'layout_section',
                    'label'    => esc_html__( 'Layout', 'immigway' ),
                    'tab'      => 'layout',
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'post_type',
                                'label'    => esc_html__( 'Select Post Type', 'immigway' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => immigway_get_post_type_options($pt_supports),
                                'default'  => 'post'
                            ) 
                        ),
                        immigway_get_post_carousel_layout($pt_supports)
                    ),
                ),
                array(
                    'name' => 'section_source',
                    'label' => esc_html__('Source', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array_merge(
                        array(
                            array(
                                'name'     => 'select_post_by',
                                'label'    => esc_html__( 'Select posts by', 'immigway' ),
                                'type'     => 'select',
                                'multiple' => true,
                                'options'  => [
                                    'term_selected' => esc_html__( 'Terms selected', 'immigway' ),
                                    'post_selected' => esc_html__( 'Posts selected ', 'immigway' ),
                                ],
                                'default'  => 'term_selected'
                            ) 
                        ),
                        immigway_get_grid_term_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'term_selected']]),
                        immigway_get_grid_ids_by_posttype($pt_supports, ['custom_condition' => ['select_post_by' => 'post_selected']]),
                        array(
                            array(
                                'name' => 'orderby',
                                'label' => esc_html__('Order By', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'date',
                                'options' => [
                                    'date' => esc_html__('Date', 'immigway' ),
                                    'ID' => esc_html__('ID', 'immigway' ),
                                    'author' => esc_html__('Author', 'immigway' ),
                                    'title' => esc_html__('Title', 'immigway' ),
                                    'rand' => esc_html__('Random', 'immigway' ),
                                ],
                            ),
                            array(
                                'name' => 'order',
                                'label' => esc_html__('Sort Order', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'default' => 'desc',
                                'options' => [
                                    'desc' => esc_html__('Descending', 'immigway' ),
                                    'asc' => esc_html__('Ascending', 'immigway' ),
                                ],
                            ),
                            array(
                                'name' => 'limit',
                                'label' => esc_html__('Total items', 'immigway' ),
                                'type' => \Elementor\Controls_Manager::NUMBER,
                                'default' => '6',
                            ),
                        )
                    ),
                ),
                array(
                    'name' => 'section_carousel',
                    'label' => esc_html__('Carousel', 'immigway'),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'pxl_animate',
                            'label' => esc_html__('Bisbuzz Animate', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => immigway_widget_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                                'auto' => 'auto',
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                                'auto' => 'auto',
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '6' => '6',
                                'auto' => 'auto',
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                'auto' => 'auto',
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                'auto' => 'auto',
                            ],
                        ),
                        array(
                            'name' => 'col_xxl',
                            'label' => esc_html__('Columns XXL Devices', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                'auto' => 'auto',
                            ],
                        ),

                        array(
                            'name' => 'slides_to_scroll',
                            'label' => esc_html__('Slides to scroll', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                            ],
                        ),
                        array(
                            'name' => 'arrows',
                            'label' => esc_html__('Show Arrows', 'immigway'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'pagination',
                            'label' => esc_html__('Show Pagination', 'immigway'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'bullets',
                            'options' => [
                                'bullets' => 'Bullets',
                                'fraction' => 'Fraction',
                                'progressbar' => 'Progressbar',
                            ],
                            'condition' => [
                                'pagination' => 'true'
                            ]
                        ),
                        array(
                            'name' => 'pagination_bullet_style',
                            'label' => esc_html__('Bullets Style', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style-6',
                            'options' => [
                                'style-1' => 'Style 1',
                                'style-2' => 'Style 2',
                                'style-3' => 'Style 3',
                                'style-4' => 'Style 4',
                                'style-5' => 'Style 5',
                                'style-6' => 'Style 6',
                            ],
                            'condition' => [
                                'pagination_type' => 'bullets'
                            ]
                        ),
                        array(
                            'name' => 'bullets_color',
                            'label' => esc_html__('Bullets Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-dots.pxl-swiper-pagination-bullets span' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'pagination_type' => 'bullets'
                            ]
                        ), 
                        array(
                            'name' => 'bullets_color_active',
                            'label' => esc_html__('Bullets Color Active', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-dots.pxl-swiper-pagination-bullets span.swiper-pagination-bullet-active ' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'pagination_type' => 'bullets'
                            ]
                        ),
                        array(
                            'name' => 'border_bullets_color_active',
                            'label' => esc_html__('Border Bullets Color Active', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-dots.pxl-swiper-pagination-bullets span.swiper-pagination-bullet-active:before' => 'border-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'pagination_type' => 'bullets'
                            ]
                        ),
                        array(
                            'name' => 'pause_on_hover',
                            'label' => esc_html__('Pause on Hover', 'immigway'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'autoplay',
                            'label' => esc_html__('Autoplay', 'immigway'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                        array(
                            'name' => 'autoplay_speed',
                            'label' => esc_html__('Autoplay Delay', 'immigway'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 5000,
                            'condition' => [
                                'autoplay' => 'false'
                            ]
                        ),
                        array(
                            'name' => 'infinite',
                            'label' => esc_html__('Infinite Loop', 'immigway'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'speed',
                            'label' => esc_html__('Animation Speed', 'immigway'),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 500,
                        ),
                        array(
                            'name' => 'drap',
                            'label' => esc_html__('Show Scroll Drap', 'immigway'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_display',
                    'label' => esc_html__('Display', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                    'controls' => array(
                        array(
                            'name' => 'img_size',
                            'label' => esc_html__('Image Size', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'description' => 'Enter image size (Example: "thumbnail", "medium", "large", "full" or other sizes defined by theme). Alternatively enter size in pixels (Default: 370x300 (Width x Height)).',
                        ),

                        array(
                            'name' => 'style_portfolio_l2',
                            'label' => esc_html__('Style', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style-1',
                            'options' => [
                                'style-1' => 'Style 1',
                                'style-2' => 'Style 2',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-2']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-2']]
                                        ]
                                    ]
                                ],
                            ]
                        ),

                        array(
                            'name' => 'style_post_l1',
                            'label' => esc_html__('Style', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style-1',
                            'options' => [
                                'style-1' => 'Style 1',
                                'style-2' => 'Style 2',
                                'style-3' => 'Style 3',
                                'style-4' => 'Style 4',
                            ],
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ]
                        ),

                        array(
                            'name' => 'show_category',
                            'label' => esc_html__('Show Category', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'portfolio'],
                                            ['name' => 'layout_portfolio', 'operator' => 'in', 'value' => ['portfolio-1','portfolio-2']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_date',
                            'label' => esc_html__('Show Date', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_comment_count',
                            'label' => esc_html__('Show Comment Count', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-2']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_author',
                            'label' => esc_html__('Show Author', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_excerpt',
                            'label' => esc_html__('Show Excerpt', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-3','service-4']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'country'],
                                            ['name' => 'layout_country', 'operator' => 'in', 'value' => ['country-1']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'num_words',
                            'label' => esc_html__('Number of Words', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 25,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ],
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-3','service-4']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'country'],
                                            ['name' => 'layout_country', 'operator' => 'in', 'value' => ['country-1']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'line_words',
                            'label' => esc_html__('Line of Words', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => 2,
                            'separator' => 'after',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'country'],
                                            ['name' => 'layout_country', 'operator' => 'in', 'value' => ['country-1']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-4']]
                                        ]
                                    ],
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_plane',
                            'label' => esc_html__('Show Line and Plane Don\'t Need Hover', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'false',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-4']]
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'show_button',
                            'label' => esc_html__('Show Button Readmore', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                        ],
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-3','service-4']]
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'country'],
                                            ['name' => 'layout_country', 'operator' => 'in', 'value' => ['country-1']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ]

                                ],
                            ]
                        ),
                        array(
                            'name' => 'button_text',
                            'label' => esc_html__('Button Readmore Text', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'conditions' => [
                                'relation' => 'or',
                                'terms' => [
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                            ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']],
                                            ['name' => 'show_button', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                            ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-1','service-3','service-4']],
                                            ['name' => 'show_button', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ],
                                    [
                                        'terms' => [
                                            ['name' => 'post_type', 'operator' => '==', 'value' => 'country'],
                                            ['name' => 'layout_country', 'operator' => 'in', 'value' => ['country-1']],
                                            ['name' => 'show_excerpt', 'operator' => '==', 'value' => 'true']
                                        ]
                                    ]
                                ],
                            ]
                        ),
                        array(
                            'name' => 'offset_left',
                            'label' => esc_html__('Offset Left', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-sliders .pxl-swiper-container' => 'margin-left: -{{SIZE}}{{UNIT}};',
                            ],
                        ),
                        array(
                            'name' => 'offset_right',
                            'label' => esc_html__('Offset Right', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 3000,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-swiper-sliders .pxl-swiper-container' => 'margin-right: -{{SIZE}}{{UNIT}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_blog',
                    'label' => esc_html__('Style', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                            [
                                'terms' => [
                                    ['name' => 'post_type', 'operator' => '==', 'value' => 'post'],
                                    ['name' => 'layout_post', 'operator' => 'in', 'value' => ['post-1']]
                                ]
                            ]
                        ],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'main_color',
                            'label' => esc_html__('Primary Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}}' => '--primary-color:{{VALUE}};--third-color:{{VALUE}};',
                            ],
                        ),
                    ),
                ),

                array(
                    'name' => 'section_style_normal',
                    'label' => esc_html__('Item Normal', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                            [
                                'terms' => [
                                    ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                    ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-3']]
                                ]
                            ]
                        ],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Icon Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-style3 .pxl-flipbox--front .pxl-item--icon' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_box_color',
                            'label' => esc_html__('Icon Box Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-style3 .pxl-flipbox--front .pxl-item--icon' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_color',
                            'label' => esc_html__('Button Readmore Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-style3 .pxl-flipbox--front .pxl-item--readmore a' => 'color: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_normal_service_4',
                    'label' => esc_html__('Item Normal', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                            [
                                'terms' => [
                                    ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                    ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-4']]
                                ]
                            ]
                        ],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'icon_color_S4',
                            'label' => esc_html__('Icon Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--icon i' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_bgr_color',
                            'label' => esc_html__('Icon Background Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--icon' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_border_color',
                            'label' => esc_html__('Icon Background Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--icon' => 'border-color: {{VALUE}};',
                            ],
                            'separator' => 'after'
                        ),
                        array(
                            'name' => 'hover_icon_color_S4',
                            'label' => esc_html__('Hover Icon Color ', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner:hover .pxl-item--holder .pxl-item--icon i' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'hover_icon_bgr_color',
                            'label' => esc_html__('Hover Icon Background Color ', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner:hover .pxl-item--holder .pxl-item--icon' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'hover_icon_border_color',
                            'label' => esc_html__('Color Icon Boder ', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner:hover .pxl-item--holder .pxl-item--icon' => 'border-color: {{VALUE}};',
                            ],
                            'separator' => 'after'
                        ),
                        array(
                            'name' => 'title_color_s4',
                            'label' => esc_html__('Title Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--title a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_color_hover_s4',
                            'label' => esc_html__('Title Color Hover', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--title a:hover' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'after'
                        ),
                        array(
                            'name' => 'line_color_s4',
                            'label' => esc_html__('Line Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-line-paper:before' => 'border-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'plane_color_s4',
                            'label' => esc_html__('Plane Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-line-paper:after' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'after'
                        ),
                        array(
                            'name' => 'excerpt_color_s4',
                            'label' => esc_html__('Excerpt Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--content' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'after'
                        ),
                        array(
                            'name' => 'button_color_s4',
                            'label' => esc_html__('Button Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--button a ' => 'color: {{VALUE}};',
                            ],
                        ), 
                        array(
                            'name' => 'button_color_hover_s4',
                            'label' => esc_html__('Button Color Hover', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--button a:hover' => 'color: {{VALUE}};',
                            ],
                            'separator' => 'after'
                        ),
                        array(
                            'name' => 'border_color_s4',
                            'label' => esc_html__('Border Content Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder' => 'border-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'svg_color_s4',
                            'label' => esc_html__('Border Icon Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--icon' => 'border-color: {{VALUE}};',
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder .pxl-item--icon svg' => 'fill: {{VALUE}};',
                            ],
                            'separator' => 'after'
                        ),

                        array(
                            'name' => 'box_color_s4',
                            'label' => esc_html__('Box Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'hover_box_color_s4',
                            'label' => esc_html__('Hover Box Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner:hover .pxl-item--holder' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name'         => 'btn_box_shadow_s4',
                            'label' => esc_html__( 'Box Shadow', 'immigway' ),
                            'type'         => \Elementor\Group_Control_Box_Shadow::get_type(),
                            'control_type' => 'group',
                            'selector'     => '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner:hover .pxl-item--holder',
                        ),
                        array(
                            'name' => 'border_box_color_s4',
                            'label' => esc_html__('Border Box Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder' => 'border-color: {{VALUE}};',
                            ],
                        ),

                        array(
                            'name' => 'border_box_hover_color_s4',
                            'label' => esc_html__('Hover Border Box Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner:hover .pxl-item--holder' => 'border-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'box_radius_s4',
                            'label' => esc_html__('Border Radius', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'size_units' => [ 'px' ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-carousel4 .pxl-item--inner .pxl-item--holder' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                            'separator' => 'after'
                        ),
                    ),
                ),
                 array(
                    'name' => 'section_style_country',
                    'label' => esc_html__('Style Country', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                            [
                                'terms' => [
                                    ['name' => 'post_type', 'operator' => '==', 'value' => 'country'],
                                    ['name' => 'layout_country', 'operator' => 'in', 'value' => ['country-1']]
                                ]
                            ]
                        ],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'country_bgr_tab_active_bgr_color',
                            'label' => esc_html__('Tab Background Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .swiper-slide-active .pxl-item-title' => 'background-color: {{VALUE}};',
                            ],
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'country_title_color',
                            'label' => esc_html__('Title Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .pxl-item-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_active_title_color',
                            'label' => esc_html__('Title Active Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .swiper-slide-active .pxl-item-title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_title_typography',
                            'label' => esc_html__('Title Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .pxl-item-title',
                        ),
                        array(
                            'name' => 'border_tab_color',
                            'label' => esc_html__('Border Tab Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel1 .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide' => 'border-color: {{VALUE}};',
                            ],
                            'separator' => 'after',
                        ),

                        array(
                            'name' => 'country_sub_title_inner_color',
                            'label' => esc_html__('Sub Title Inner Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel1 .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--subtitle' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_sub_title_inner_typography',
                            'label' => esc_html__('Sub Title Inner Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-country-carousel1 .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--subtitle',
                            'separator' => 'after',
                        ),

                        array(
                            'name' => 'country_title_inner_color',
                            'label' => esc_html__('Title Inner Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .pxl-item--holder .pxl-item--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_title_inner_typography',
                            'label' => esc_html__('Title Inner Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .pxl-item--holder .pxl-item--title',
                            'separator' => 'after',
                        ),

                        array(
                            'name' => 'country_excerpt_inner_color',
                            'label' => esc_html__('Excerpt Inner Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .pxl-item--holder .pxl-item--content' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_excerpt_inner_typography',
                            'label' => esc_html__('Excerpt Inner Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .pxl-item--holder .pxl-item--content',
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'country_multi_text_inner_color',
                            'label' => esc_html__('Multi Text Inner Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .multi-text li p ' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_multi_text_icon_inner_color',
                            'label' => esc_html__('Multi Text Icon Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .multi-text li i ' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_multi_text_icon_overlay_inner_color',
                            'label' => esc_html__('Multi Text Icon Overlay Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .multi-text li i:after ' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_multi_text_icon_bgr_inner_color',
                            'label' => esc_html__('Multi Text Icon Background Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .multi-text li i ' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_multi_text_border_inner_color',
                            'label' => esc_html__('Multi Text Border Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .multi-text li ' => 'border-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_multi_text_inner_typography',
                            'label' => esc_html__('Multi Text Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .multi-text li p',
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'country_button_inner_color',
                            'label' => esc_html__('Button Inner Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn ' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_button_hover_inner_color',
                            'label' => esc_html__('Button Inner Color Hover', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn:hover ' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'country_button_inner_typography',
                            'label' => esc_html__('Button Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn',
                        ),
                        array(
                            'name' => 'country_button_bgr_inner_color',
                            'label' => esc_html__('Button Background Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn ' => 'background-color: {{VALUE}};',
                            ],
                        ), 
                        array(
                            'name' => 'country_button_bgr_hover_inner_color',
                            'label' => esc_html__('Button Background Color Hover', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--holder .pxl-item--readmore .btn:hover ' => 'background-color: {{VALUE}};',
                            ],
                            'separator' => 'after',
                        ),
                         array(
                            'name' => 'border_img_color',
                            'label' => esc_html__('Image Border Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-country-carousel .pxl-carousel-inner .pxl-swiper-wrapper .pxl-swiper-slide .wrap-inner .pxl-item--inner .pxl-item--featured img' => 'border-color: {{VALUE}};',
                            ],
                           
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_hover',
                    'label' => esc_html__('Item Hover', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'conditions' => [
                        'relation' => 'or',
                        'terms' => [
                            [
                                'terms' => [
                                    ['name' => 'post_type', 'operator' => '==', 'value' => 'service'],
                                    ['name' => 'layout_service', 'operator' => 'in', 'value' => ['service-3']]
                                ]
                            ]
                        ],
                    ],
                    'controls' => array(
                        array(
                            'name' => 'divider_color',
                            'label' => esc_html__('Divider Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-shape--divider .pxl-item--divider' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'overlay_color',
                            'label' => esc_html__('Overlay Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-style3 .pxl-flipbox--back .pxl-item--featured::before' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-style3 .pxl-flipbox--back .pxl-item--title' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_color_hover',
                            'label' => esc_html__('Icon Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-style3 .pxl-flipbox--back .pxl-item--icon' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_box_color_hover',
                            'label' => esc_html__('Icon Box Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-style3 .pxl-flipbox--back .pxl-item--icon' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_color_hover',
                            'label' => esc_html__('Button Readmore Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-style3 .pxl-flipbox--back .pxl-item--readmore a:not(:hover)' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'button_box_color',
                            'label' => esc_html__('Button Readmore Box Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-service-style3 .pxl-flipbox--back .pxl-item--readmore a:not(:hover)' => 'background-color: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
               
            ),
        ),
    ),
    immigway_get_class_widget_path()
);