<?php
// Register Button Widget
pxl_add_custom_widget(
    array(
        'name' => 'pxl_icon_user',
        'title' => esc_html__('PXL User', 'immigway' ),
        'icon' => 'eicon-lock-user',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source Settings', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'style',
                            'label' => esc_html__('Style', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style1',
                            'options' => [
                                'style1' => esc_html__('Style 1 (Popup)', 'immigway' ),
                            ],
                        ),
                        array(
                            'name' => 'text_placeholder',
                            'label' => esc_html__('Text Placeholder', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'style' => ['style2', 'style3'],
                            ],
                        ),
                        array(
                            'name' => 'text_button',
                            'label' => esc_html__('Text Button', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'style' => 'style3',
                            ],
                        ),
                        array(
                            'name' => 'quick_user',
                            'label' => esc_html__('Quick User', 'immigway'),
                            'type' => \Elementor\Controls_Manager::REPEATER,
                            'controls' => array(
                                array(
                                    'name' => 'content',
                                    'label' => esc_html__('Content', 'immigway'),
                                    'type' => \Elementor\Controls_Manager::TEXT,
                                    'label_block' => true,
                                ),
                            ),
                            'title_field' => '{{{ content }}}',
                            'condition' => [
                                'style' => 'style3',
                            ],
                        ),
                        array(
                            'name' => 'post_type',
                            'label' => esc_html__('User Post Type', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '',
                            'options' => [
                                '' => esc_html__('All', 'immigway' ),
                                'page' => esc_html__('Page', 'immigway' ),
                                'post' => esc_html__('Post', 'immigway' ),
                                'lp_course' => esc_html__('Course', 'immigway' ),
                                'portfolio' => esc_html__('Portfolio', 'immigway' ),
                                'product' => esc_html__('Product', 'immigway' ),
                            ],
                        ),
                        array(
                            'name' => 'show_icon_not_content',
                            'label' => esc_html__('Show icon only for screen < 1600px', 'immigway' ),
                            'description' => 'This is only needed for areas that are too small',
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'pxl-yes' => 'Yes',
                                'pxl-no' => 'No',
                            ],
                            'default' => 'pxl-no',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style',
                    'label' => esc_html__('Text Color', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                       
                        array(
                            'name' => 'third_color',
                            'label' => esc_html__('Text Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon--users a' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'third_color_hover',
                            'label' => esc_html__('Text Color Hover', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon--users a:hover' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_typography',
                            'label' => esc_html__('Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-icon--users a, {{WRAPPER}} .pxl-icon--users ',
                        ),
                        array(
                            'name' => 'other_third_color',
                            'label' => esc_html__('Other Text Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon--users' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'other_text_typography',
                            'label' => esc_html__('Other Typography', 'immigway' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-icon--users',
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_icon',
                    'label' => esc_html__('Icon Color', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                       
                        array(
                            'name' => 'icon_color',
                            'label' => esc_html__('Icon Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon--users i' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'icon_color_hover',
                            'label' => esc_html__('Icon Color Hover', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-icon--users:hover i' => 'color: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    immigway_get_class_widget_path()
);