<?php
$templates_df = ['0' => esc_html__('None', 'immigway')];
$templates = $templates_df + immigway_get_templates_option('hidden-panel') ;
pxl_add_custom_widget(
    array(
        'name' => 'pxl_hidden_panel',
        'title' => esc_html__('BR Hidden Panel', 'immigway' ),
        'icon' => 'eicon-menu-bar',
        'categories' => array('pxltheme-core'),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'immigway' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'content_template',
                            'label' => esc_html__('Select Template', 'immigway'),
                            'type' => 'select',
                            'options' => $templates,
                            'default' => 'df',
                            'description' => 'Add new tab template: "<a href="' . esc_url( admin_url( 'edit.php?post_type=pxl-template' ) ) . '" target="_blank">Click Here</a>"',
                        ),
                        array(
                            'name' => 'btn_style',
                            'label' => esc_html__('Style', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'style-1',
                            'options' => [
                                'style-1' => esc_html__('Style 1', 'immigway' ),
                                'style-2' => esc_html__('Style 2', 'immigway' ),
                                'style-3' => esc_html__('Style 3', 'immigway' ),
                            ],
                        ),
                        array(
                            'name' => 'box_color',
                            'label' => esc_html__('Box Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-hidden-panel-button.pxl-anchor-button' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'btn_style' => ['style-1','style-2'],
                            ],
                        ),
                        array(
                            'name' => 'dot_color',
                            'label' => esc_html__('Dot/Divider Color', 'immigway' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-hidden-panel-button .pxl-icon-square span, {{WRAPPER}} .pxl-hidden-panel-button .pxl-icon-round span' => 'background-color: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
            ),
        ),
    ),
    immigway_get_class_widget_path()
);