<?php 
$img_size = '';
if(!empty($settings['img_size'])) {
    $img_size = $settings['img_size'];
} else {
    $img_size = 'full';
}
?>
<div class="pxl-video-player pxl-video-player1 pxl-video-<?php echo esc_attr($settings['btn_video_style'].' '.$settings['video_style'].' '.$settings['video_image_client']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-video--inner">
        <?php if( $settings['image_type'] != 'none' && !empty( $settings['image']['url'] ) ) : 
            $img  = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $img_size,
            ) );
            $thumbnail    = $img['thumbnail'];
            ?>
            <div class="pxl-video--holder">
                <?php if ($settings['image_type'] == 'img') { ?>
                    <?php if ( ! empty( $settings['image']['url'] ) ) { echo wp_kses_post($thumbnail); } ?>
                <?php } else { ?>
                    <div class="pxl-video--imagebg bg-image" style="background-image: url(<?php echo esc_url($settings['image']['url']); ?>);"></div>
                <?php } ?>
            </div>
        <?php endif; ?>
        <?php if(!empty($settings['video_link'])) : ?>
            <div class="btn-video-wrap <?php echo esc_attr($settings['btn_video_position']); ?>">
                <a class="btn-video <?php echo esc_attr($settings['btn_video_style']); ?>" href="<?php echo esc_url($settings['video_link']); ?>">
                    <?php if ( !empty($settings['video_icon']['value']) ) { ?>
                        <?php \Elementor\Icons_Manager::render_icon( $settings['video_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                    <?php } else { ?>
                        <i class="caseicon-play1"></i>
                    <?php } ?>
                    <span class="line-video-animation line-video-1"></span>
                    <span class="line-video-animation line-video-2"></span>
                    <span class="line-video-animation line-video-3"></span>
                </a>
                <?php if($settings['btn_video_style'] == 'style2' && !empty($settings['btn_text']) || $settings['btn_video_style'] == 'style3' && !empty($settings['btn_text']) || $settings['btn_video_style'] == 'style5' && !empty($settings['btn_text']) || $settings['btn_video_style'] == 'style6' && !empty($settings['btn_text']) || $settings['btn_video_style'] == 'style7' && !empty($settings['btn_text']) ) : ?>
                    <span class="btn-video-text pxl-label pxl-ml-20"><?php echo esc_attr($settings['btn_text']); ?></span>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
    <?php if(!empty($settings['video_style'])) { ?>
        <div class="pxl-video-testimonial-wrap">
            <span class="pxl-video-testimonial-desc">“<?php echo pxl_print_html($settings['testimonial_desc']); ?>”</span>
            <span class="pxl-video-testimonial-title"><?php echo pxl_print_html($settings['testimonial_client']); ?></span>
            <span class="pxl-video-testimonial-postion"><?php echo pxl_print_html($settings['testimonial_position']); ?></span>
        </div>
    <?php } ?>
    <?php if(!empty($settings['video_image_client'])) { 
        $image_size = !empty($settings['img_client_size']) ? $settings['img_client_size'] : 'full';
        $img_client  = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image_client']['id'],
                'thumb_size' => $image_size,
            ) );
        $thumbnail_client    = $img_client['thumbnail'];
        ?>
        <div class="pxl-video-image-client">
           <?php if ( ! empty( $settings['image']['url'] ) ) { echo wp_kses_post($thumbnail_client); } ?>
        </div>
    <?php } ?>
</div>