<?php $html_id = pxl_get_element_id($settings); 
if(isset($settings['tabs']) && !empty($settings['tabs']) && count($settings['tabs'])): 
    $tab_bd_ids = [];
    ?>
    <div class="pxl-tabs pxl-tabs-banner1 tab-effect-fade <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <div class="pxl-tabs--inner ">
            <div class="pxl-col--right">
                <div class="pxl-tabs--content">
                    <?php foreach ($settings['tabs'] as $key => $content) : 
                        $banner_image = isset($content['banner_image']) ? $content['banner_image'] : ''; ?>
                        <div id="<?php echo esc_attr($html_id.'-'.$content['_id']); ?>" class="pxl-tab--content <?php if($settings['tab_active'] == $key + 1) { echo 'active'; } ?> <?php if($content['content_type'] == 'template') { echo 'pxl-tabs--elementor'; } ?>" <?php if($settings['tab_active'] == $key + 1) { ?>style="display: block;"<?php } ?>>
                            <?php if(!empty($banner_image['id'])) { 
                                $img = pxl_get_image_by_size( array(
                                    'attach_id'  => $banner_image['id'],
                                    'thumb_size' => 'full',
                                    'class' => 'no-lazyload',
                                ));
                                $thumbnail_url = $img['url']; ?>
                                <div class="bg-image" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);"></div>
                            <?php } ?>
                            <div class="pxl-content--wrap">
                                <?php if($content['content_type'] == 'df' && !empty($content['desc'])) {
                                    echo pxl_print_html($content['desc']); 
                                } elseif($content['content_type'] == 'template' && !empty($content['content_template'])) {
                                    $tab_content = Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$content['content_template']);
                                    $tab_bd_ids[] = (int)$content['content_template'];
                                    pxl_print_html($tab_content);
                                } ?>    
                            </div>    
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="pxl-col--left">
                <div class="pxl-col--inner">
                    <?php if(!empty($settings['wg_title']) || !empty($settings['wg_subtitle'])) : ?>
                        <div class="pxl-tab-heading">
                            <div class="pxl-heading">
                                <div class="pxl-heading--inner">
                                    <?php if(!empty($settings['wg_subtitle'])) : ?>
                                        <div class="pxl-item--subtitle px-sub-title-box1">
                                            <span class="pxl-item--subtext"><?php echo esc_attr($settings['wg_subtitle']); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <h3 class="pxl-item--wgtitle <?php echo esc_attr($settings['pxl_wg_animate']); ?>"><?php echo esc_attr($settings['wg_title']); ?></h3>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="pxl-tabs--title">
                        <?php foreach ($settings['tabs'] as $key => $title) : ?>
                            <span class="pxl-tab--title pxl-cursor--cta <?php if($settings['tab_active'] == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.'-'.$title['_id']); ?>">
                               <span class="pxl-title--text">
                                    <?php echo pxl_print_html($title['title']); ?>
                                </span>        
                            </span>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

           
            
        </div>
    </div>
<?php endif; ?>