<div class="pxl-showcase pxl-showcase1 <?php echo esc_attr($settings['pxl_animate'].' '.$settings['active']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
	<div class="pxl-item--inner">
		<div class="pxl-item--meta">
			<?php if(!empty($settings['title'])) : ?>
				<h5 class="pxl-item--title">
					<?php echo esc_attr($settings['title']); ?>
				</h5>
			<?php endif; ?>
			<?php if(!empty($settings['sub_title'])) : ?>
				<div class="pxl-item--subtitle">
					<?php echo esc_attr($settings['sub_title']); ?>
				</div>
			<?php endif; ?>
		</div>
		<?php if(!empty($settings['image1']['id'])) : 
			$img = pxl_get_image_by_size( array(
				'attach_id'  => $settings['image1']['id'],
				'thumb_size' => 'full',
			));
			$thumbnail = $img['thumbnail']; ?>
			<div class="pxl-item--colleft">
				<div class="pxl-item--image1">
					<?php echo pxl_print_html($thumbnail); ?>
				</div>
			</div>
		<?php endif; ?>
		<?php if(!empty($settings['image2']['id'])) : 
			$img2 = pxl_get_image_by_size( array(
				'attach_id'  => $settings['image2']['id'],
				'thumb_size' => 'full',
			));
			$thumbnail2 = $img2['thumbnail']; ?>
			<div class="pxl-item--colright">
				<div class="pxl-item--image2">
					<?php echo pxl_print_html($thumbnail2); ?>
				</div>
			</div>
		<?php endif; ?>
		<div class="pxl-item--buttons">
			<?php if(!empty($settings['btn_text'])) : 
				if ( ! empty( $settings['btn_link']['url'] ) ) {
				    $widget->add_render_attribute( 'button', 'href', $settings['btn_link']['url'] );

				    if ( $settings['btn_link']['is_external'] ) {
				        $widget->add_render_attribute( 'button', 'target', '_blank' );
				    }

				    if ( $settings['btn_link']['nofollow'] ) {
				        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
				    }
				} ?>
				<div class="pxl-item--readmore">
					<a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?> class="btn btn-skew btn-color1"><?php echo esc_attr($settings['btn_text']); ?></a>
				</div>
			<?php endif; ?>
			<?php if(!empty($settings['btn_text2'])) : 
				if ( ! empty( $settings['btn_link2']['url'] ) ) {
				    $widget->add_render_attribute( 'button2', 'href', $settings['btn_link2']['url'] );

				    if ( $settings['btn_link2']['is_external'] ) {
				        $widget->add_render_attribute( 'button2', 'target', '_blank' );
				    }

				    if ( $settings['btn_link2']['nofollow'] ) {
				        $widget->add_render_attribute( 'button2', 'rel', 'nofollow' );
				    }
				} ?>
				<div class="pxl-item--readmore">
					<a <?php pxl_print_html($widget->get_render_attribute_string( 'button2' )); ?> class="btn btn-secondary btn-skew btn-color2"><?php echo esc_attr($settings['btn_text2']); ?></a>
				</div>
			<?php endif; ?>
		</div>
		<div class="pxl-item--overlay"></div>
	</div>
</div>