<?php if($settings['search_type'] == 'popup') : ?>
	<div class="pxl-search-popup-button pxl-cursor--cta <?php echo esc_attr($settings['style']); ?>">
		<?php if(!empty($settings['pxl_icon']['value'])) {
	            \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' );
	    } else { ?>
	    	<i class="caseicon-search"></i>
	    <?php } ?>
	</div>
	<?php add_action( 'pxl_anchor_target', 'immigway_hook_anchor_search'); ?>
<?php endif; ?>

<?php if($settings['search_type'] == 'form') : ?>
	<form role="search" method="get" class="pxl-widget-searchform <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" action="<?php echo esc_url(home_url( '/' )); ?>">
		<div class="searchform-wrap">
	        <input type="text" placeholder="<?php if(!empty($settings['email_placefolder'])) { echo esc_attr($settings['email_placefolder']); } else { esc_attr_e('Search...', 'immigway'); } ?>" name="s" class="search-field" />
	    	<button type="submit" class="search-submit"><i class="flaticon-search"></i></button>
	    </div>
	</form>
<?php endif; ?>

<?php if($settings['search_type'] == 'form2') : ?>
	<form role="search" method="get" class="pxl-widget-searchform2 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" action="<?php echo esc_url(home_url( '/' )); ?>">
		<div class="searchform-wrap">
	        <input type="text" placeholder="<?php if(!empty($settings['email_placefolder'])) { echo esc_attr($settings['email_placefolder']); } else { esc_attr_e('Search here', 'immigway'); } ?>" name="s" class="search-field" />
	    	<button type="submit" class="search-submit"><i class="flaticon-search"></i><?php echo pxl_print_html('<span class="pxl-search-button-text">'.$settings['text_button_search'].'</span>'); ?></button>
	    </div>
	</form>
<?php endif; ?>