<div class="pxl-project-info1">
    <?php if(!empty($settings['title'])) : ?>
        <h5 class="pxl-item--title">
            <?php echo esc_attr($settings['title']); ?>
        </h5>
    <?php endif; ?>
    <?php if(isset($settings['items']) && !empty($settings['items']) && count($settings['items'])): 
        $is_new = \Elementor\Icons_Manager::is_migration_allowed();  ?>
        <div class="pxl--holder">
            <?php foreach ($settings['items'] as $key => $value):
                $label = isset($value['label']) ? $value['label'] : '';
                $content = isset($value['content']) ? $value['content'] : ''; 
                $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                $widget->add_render_attribute( $icon_key, [
                    'class' => $value['pxl_icon'],
                    'aria-hidden' => 'true',
                ] ); ?>
                <div class="pxl--item">
                    <?php if ( $is_new ): ?>
                        <div class="pxl--icon pxl-mr-20"><?php \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] ); ?></div>
                    <?php elseif(!empty($value['pxl_icon'])): ?>
                        <div class="pxl--icon pxl-mr-20"><i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i></div>
                    <?php endif; ?>
                    <div class="pxl--meta">
                        <?php if(!empty($label)) : ?>
                            <label class="pxl-pr-10"><?php echo esc_attr($label); ?></label>
                        <?php endif; ?>
                        <?php if(!empty($content)) : ?>
                            <span><?php echo pxl_print_html($content); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>