<?php
if ( ! empty( $settings['button_link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['button_link']['url'] );

    if ( $settings['button_link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['button_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-pricing pxl-pricing1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <h5 class="pxl-item--title el-empty"><span><?php echo esc_attr($settings['title']); ?></span></h5>
    <?php if(!empty($settings['pxl_icon'])) : ?>
        <div class="pxl-item--icon"><?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?></div>
    <?php endif; ?>
    <div class="pxl-item--meta">
        <div class="pxl-item--price">
            <span class="pxl-item--currency"><?php echo pxl_print_html($settings['currency']); ?></span>
            <span class="pxl-price--number"><?php echo pxl_print_html($settings['price']); ?></span>
        </div>
        <div class="pxl-item--time el-empty"><?php echo pxl_print_html($settings['time']); ?></div>
    </div>
    <?php if(!empty($settings['button_text'])) : ?>
        <div class="pxl-item--button">
            <a class="btn btn-outline" <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>>
                <?php echo esc_attr($settings['button_text']); ?>
            </a>
        </div>
    <?php endif; ?>
    <div class="pxl-item--footer pxl-text-left">
        <?php if(isset($settings['feature']) && !empty($settings['feature']) && count($settings['feature'])): ?>
            <div class="pxl-item--feature">
                <?php foreach ($settings['feature'] as $key => $value): ?>
                    <div class="<?php echo esc_attr($value['active']); ?>">
                        <i class="caseicon-check pxl-mr-10"></i>
                        <?php if($value['active'] == 'non-active') { ?><del><?php } ?>
                            <?php echo pxl_print_html($value['feature_text'])?>
                        <?php if($value['active'] == 'non-active') { ?></del><?php } ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <div class="pxl-item--bottom el-empty"><?php echo esc_attr($settings['bottom_text']); ?></div>
    </div>
    <div class="pxl-item--shape">
        <div class="pxl-item--divider pxl-item--divider1"></div>
        <div class="pxl-item--divider pxl-item--divider2"></div>
        <div class="pxl-item--divider pxl-item--divider3"></div>
        <div class="pxl-item--divider pxl-item--divider4"></div>
    </div>
</div>