<?php
$html_id = pxl_get_element_id($settings);
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(pxl_get_posts_of_grid('country', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$pxl_animate = $widget->get_setting('pxl_animate', '');
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');
$img_size = $widget->get_setting('img_size');
$arrows = $widget->get_setting('arrows','false');
$pagination = $widget->get_setting('pagination','false');
$pagination_type = $widget->get_setting('pagination_type','bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

$show_category = $widget->get_setting('show_category');
$show_excerpt = $widget->get_setting('show_excerpt');
$show_button = $widget->get_setting('show_button');
$num_words = $widget->get_setting('num_words');
$line_words = $widget->get_setting('line_words');


$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => '1', 
    'slide_percolumnfill'           => '1', 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => $col_xl,
    'slides_to_show_xxl'            => $col_xxl,  
    'slides_to_show_lg'             => $col_lg, 
    'slides_to_show_md'             => $col_md, 
    'slides_to_show_sm'             => $col_sm, 
    'slides_to_show_xs'             => $col_xs, 
    'slides_to_scroll'              => $slides_to_scroll,  
    'slides_gutter'                 => 30, 
    'arrow'                         => $arrows,
    'pagination'                    => $pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => $autoplay,
    'pause_on_hover'                => $pause_on_hover,
    'pause_on_interaction'          => 'true',
    'delay'                         => $autoplay_speed,
    'loop'                          => $infinite,
    'speed'                         => $speed,
    'effect'                         => 'slide',

];

$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); ?>

<?php if (is_array($posts)): ?>
    <div class="pxl-swiper-sliders pxl-country-carousel pxl-country-carousel1 pxl-country-style1" <?php if($settings['drap'] !== 'false') : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'immigway'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php
                    foreach ($posts as $key => $post):
                        $image_size = !empty($img_size) ? $img_size : '420x420'; 
                        $icon_multi_text = get_post_meta($post->ID, 'icon_multi_text', true);
                        $custom_country_title_carousel = get_post_meta($post->ID, 'custom_country_title_carousel', true);
                        $multi_text_country = get_post_meta($post->ID, 'multi_text_country', true);
                        $post_excerpt= get_the_excerpt($post->ID, 'post_excerpt', true);
                        
                        if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                            $img_id       = get_post_thumbnail_id( $post->ID );
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $image_size,
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail']; ?>
                        <div class="pxl-swiper-slide">
                            <h3 class="pxl-item-title">
                             <span><?php echo esc_attr(get_the_title($post->ID)); ?></span>
                             <div class="pxl-item-featured">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </div>
                        </h3> 
                        <div class="wrap-inner">  
                        <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>">
                            <div class="pxl-item--holder">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" title="<?php echo esc_attr(get_the_title($post->ID)); ?>" class="pxl-item--subtitle">
                                    <?php echo esc_attr(get_the_title($post->ID)); ?>
                                </a>
                                <h6 class="pxl-item--title">
                                    <?php if(!empty($custom_country_title_carousel)) { ?>
                                        <?php echo pxl_print_html($custom_country_title_carousel); ?>
                                    <?php } else { ?>
                                        <?php echo pxl_print_html('Visa & Immigration Services To '. get_the_title($post->ID)); ?>
                                    <?php } ?>
                                </h6>
                                <?php if($show_excerpt == 'true' && !empty($post_excerpt)): ?>
                                    <div class="pxl-item--content pxl-excerpt-line" style="-webkit-line-clamp: <?php echo esc_attr($line_words); ?>;">
                                        <?php echo wp_trim_words( $post_excerpt, $num_words, $more = null ); ?>
                                    </div>
                                <?php endif; ?>
                                <?php if (!empty($multi_text_country)): 
                                    $count = 0;
                                    $count_li = 0;
                                    $nth_first_item_nd_column = 0;
                                    ?>
                                    <?php foreach ($multi_text_country as $text): 
                                        $count++;
                                    endforeach; 
                                        $nth_first_item_nd_column = floor($count / 2) + 1; 
                                        if($count % 2 != 0){
                                            $count ++;
                                            $nth_first_item_nd_column = floor($count / 2) + 1; 
                                        }
                                    ?>

                                    <ul class="multi-text">
                                        <?php foreach ($multi_text_country as $text):
                                            $count_li++; 
                                            if($count % 2 == 0){
                                                if($nth_first_item_nd_column % 2 == 0 ){
                                                    if ($count_li == $nth_first_item_nd_column) {
                                                        ?>
                                                        <li class="box-multi border-0-p0">
                                                            <i class="<?php echo esc_attr($icon_multi_text); ?>"></i>
                                                            <p><?php echo pxl_print_html($text); ?></p>
                                                        </li>
                                                        <?php
                                                    } else { ?>
                                                        <li class="box-multi">
                                                            <i class="<?php echo esc_attr($icon_multi_text); ?>"></i>
                                                            <p><?php echo pxl_print_html($text); ?></p>
                                                        </li>
                                                        <?php
                                                    }  
                                                }
                                                else { 
                                                    if ($count_li == $nth_first_item_nd_column) { ?>
                                                        <li class="box-multi border-0-p0">
                                                            <i class="<?php echo esc_attr($icon_multi_text); ?>"></i>
                                                            <p><?php echo pxl_print_html($text); ?></p>
                                                        </li>
                                                        <?php
                                                    }   
                                                    else { ?>
                                                        <li class="box-multi">
                                                            <i class="<?php echo esc_attr($icon_multi_text); ?>"></i>
                                                            <p><?php echo pxl_print_html($text); ?></p>
                                                        </li>
                                                    <?php  }
                                                }
                                            }
                                            else{ ?>

                                               <li class="box-multi">
                                                <i class="<?php echo esc_attr($icon_multi_text); ?>"></i>
                                                <p><?php echo pxl_print_html($text); ?></p>
                                            </li>
                                        <?php } 
                                        endforeach; ?>

                                </ul>
                            <?php endif; ?>
                            <?php if($show_button == 'true') : ?>
                                <div class="pxl-item--readmore">
                                    <a class="btn btn-white" href="<?php if(!empty($country_external_link)) { echo esc_url($country_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <span class="btn-readmore--text"><?php if(!empty($button_text)) {
                                            echo esc_attr($button_text);
                                        } else {
                                            echo esc_html__('CONTACT US', 'immigway');
                                        } ?></span>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="pxl-item--featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" title="<?php echo esc_attr(get_the_title($post->ID)); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </div>
                    </div>
                     </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    </div> 
</div>
<?php if($pagination !== 'false'): ?>
    <div class="pxl-swiper-dots <?php echo pxl_print_html($settings['pagination_bullet_style']); ?>"></div>
<?php endif; ?>

<?php if($arrows !== 'false'): ?>
    <div class="pxl-swiper-arrow-wrap style-2">
        <div class="pxl-swiper-arrow-inner">
            <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-angle-arrow-left rtl-icon"></i></div>
            <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-angle-arrow-right rtl-icon"></i></div>
        </div>
    </div>
<?php endif; ?>
</div>
</div>
<?php endif; ?>