<div class="pxl-download-box pxl-download-box1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <?php
    $is_new = \Elementor\Icons_Manager::is_migration_allowed();
    if(isset($settings['icons']) && !empty($settings['icons']) && count($settings['icons'])): ?>
        <?php if (!empty($settings['title_form'])) : ?>
            <h5 class="pxl-download--heading">
                <?php echo pxl_print_html($settings['title_form']); ?>
            </h5>
        <?php endif; ?>
        <div class="pxl-download--button">
            <?php foreach ($settings['icons'] as $key => $value):
                $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                $widget->add_render_attribute( $icon_key, [
                    'class' => $value['pxl_icon'],
                    'aria-hidden' => 'true',
                ] );
                $link_key = $widget->get_repeater_setting_key( 'download_link', 'value', $key );
                if ( ! empty( $value['download_link']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $value['download_link']['url'] );

                    if ( $value['download_link']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $value['download_link']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                <?php if ( ! empty( $value['pxl_icon'] ) ) : ?>
                    <a class="elementor-repeater-item-<?php echo esc_attr($value['_id']); ?>" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                    <span class="pxl-download-icon">
                        <?php if ( $is_new ) {
                            \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                        } ?>
                    </span>
                    <span class="download-content">
                        <span class="pxl-download-title">
                            <?php echo esc_attr($value['download_title']); ?>
                        </span>
                        <span class="pxl-download-format-file">
                            <?php echo esc_attr($value['download_format_file']); ?>
                        </span>
                    </span>

                </a>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>
<?php endif; ?>
</div>