<?php if ( ! empty( $settings['item_link']['url'] ) ) {
    $widget->add_render_attribute( 'item_link', 'href', $settings['item_link']['url'] );

    if ( $settings['item_link']['is_external'] ) {
        $widget->add_render_attribute( 'item_link', 'target', '_blank' );
    }

    if ( $settings['item_link']['nofollow'] ) {
        $widget->add_render_attribute( 'item_link', 'rel', 'nofollow' );
    } ?>
    
<?php } ?>
<div class="pxl-contact-info pxl-contact-info3 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if ( !empty($settings['pxl_icon']['value']) ) : ?>
            <div class="pxl-item--icon pxl-mr-8 field-dflex">
                <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
            </div>
        <?php endif; ?>
        <div class="pxl-item--meta field-dflex">
            <h5 class="pxl-item--title el-empty"><?php echo pxl_print_html($settings['title']); ?></h5>
        </div>
        <a class="pxl-item--link" <?php pxl_print_html($widget->get_render_attribute_string( 'item_link' )); ?>></a>
    </div>
</div>