<?php
$primary_color = immigway()->get_opt( 'primary_color' );
$default_settings = [
    'percentage_value' => '',
    'bar_color' => '',
    'track_color' => '',
    'chart_size' => '',
    'chart_border_width' => '',
    'pxl_animate' => '',
    'chart_line_cap' => '',
];
$settings = array_merge($default_settings, $settings);

extract($settings); ?>

<div class="pxl-client-review pxl-client-review3 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <div class="pxl-item--icon">
            <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
        </div>

        <h5 class="pxl-item--title"><?php echo pxl_print_html($settings['title']); ?></h5>
        <div class="pxl-piechart <?php echo esc_attr($pxl_animate); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
            <div class="item--value percentage" style="min-height: <?php echo esc_attr($chart_size['size']); ?>px;" data-size="<?php echo esc_attr($chart_size['size']); ?>" data-bar-color="<?php if(!empty($bar_color)) { echo esc_attr($settings['bar_color']); } else { echo esc_attr($primary_color); } ?>" data-track-color="<?php if(!empty($track_color)) { echo esc_attr($track_color); } else { echo '#edf2ff'; } ?>" data-line-width="<?php echo esc_attr($chart_border_width['size']); ?>" data-percent="-<?php echo esc_attr($percentage_value); ?>" data-line-cap="<?php echo esc_attr($chart_line_cap); ?>">
            </div>
            <div class="wrap-meta">
                <span class="pxl--rating-label"><?php echo pxl_print_html($settings['desc_number']); ?></span>
                <?php if(!empty($settings['number'])) : ?>
                    <span class="pxl--counter-number">
                        <span class="pxl--counter-value" data-duration="2000" data-to-value="<?php echo esc_attr($settings['number']); ?>" data-delimiter="">1</span>
                    </span>
                <?php endif; ?>
            </div>
            
        </div>  
        
        <div class="pxl-item--images el-empty">
            <?php foreach ($settings['images'] as $key => $value): 
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $value['id'],
                    'thumb_size' => '34x34',
                ));
                $thumbnail = $img['thumbnail'];
                ?>
                <div class="pxl-item--img">
                    <?php echo wp_kses_post($thumbnail); ?>
                </div>
            <?php endforeach; ?>
            <?php if ( ! empty( $settings['btn_link']['url'] ) ) {
                $widget->add_render_attribute( 'button', 'href', $settings['btn_link']['url'] );

                if ( $settings['btn_link']['is_external'] ) {
                    $widget->add_render_attribute( 'button', 'target', '_blank' );
                }

                if ( $settings['btn_link']['nofollow'] ) {
                    $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
                } ?>
                <a class="pxl-item--img pxl-item--link" <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?> ><i class="pxl-icon--plus"></i></a>
                <span class="pxl-item--text" ><?php echo pxl_print_html($settings['text_more_country']); ?></a>
                <?php } ?>
            </div>
            <span class="pxl-item--desc"><?php echo pxl_print_html($settings['desc']); ?></span>
        </div>
    </div>