<div class="pxl-client-review pxl-client-review2 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <span class="pxl-item-sub-title"><?php echo pxl_print_html($settings['sub_title']); ?></span>
        <h5 class="pxl-item--title"><?php echo pxl_print_html($settings['title']); ?></h5>
        <div class="pxl-item--images el-empty">
         <?php if(!empty($settings['number'])) : ?>
            <span class="pxl--counter-number">
                <span class="pxl--counter-value" data-duration="2000" data-to-value="<?php echo esc_attr($settings['number']); ?>" data-delimiter="">1</span>
            </span>
        <?php endif; ?>
        <div class="wrap-image">
            <?php foreach ($settings['images'] as $key => $value): 
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $value['id'],
                    'thumb_size' => '56x56',
                ));
                $thumbnail = $img['thumbnail'];
                ?>
                <div class="pxl-item--img">
                    <?php echo wp_kses_post($thumbnail); ?>
                </div>
            <?php endforeach; ?>
            <?php if ( ! empty( $settings['btn_link']['url'] ) ) {
                $widget->add_render_attribute( 'button', 'href', $settings['btn_link']['url'] );

                if ( $settings['btn_link']['is_external'] ) {
                    $widget->add_render_attribute( 'button', 'target', '_blank' );
                }

                if ( $settings['btn_link']['nofollow'] ) {
                    $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
                } ?>
                <a class="pxl-item--img pxl-item--link" <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?> ><?php if(!empty($settings['text_more_country'])){ ?><span class="pxl-item--text" ><?php echo pxl_print_html($settings['text_more_country']); ?></a><?php } else{ ?><i class="pxl-icon--plus"></i><?php } ?></a>
                
                <?php } ?>
            </div>
        </div>
        <div class="pxl--rating-label"><?php echo pxl_print_html($settings['rating_label']); ?></div>
        <div class="pxl-item--star">
            <span class="item-star">
                <?php $percent = ($settings['number']/5)*100;?>
                <span style="<?php echo 'width: '.$percent.'%;'; ?>"></span>
            </span>
            <span class="pxl--star-label"><?php echo pxl_print_html($settings['desc_star']); ?></span>
        </div>
    </div>
</div>