<div class="pxl-client-review pxl-client-review1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <div class="pxl-item--images el-empty">
            <?php foreach ($settings['images'] as $key => $value): 
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $value['id'],
                    'thumb_size' => '90x90',
                ));
                $thumbnail = $img['thumbnail'];
                ?>
                <div class="pxl-item--img">
                    <?php echo wp_kses_post($thumbnail); ?>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="pxl-item--meta pxl-pr-20 pxl-pl-36">
            <?php if(!empty($settings['number'])) : ?>
                <span class="pxl--counter-number">
                    <span class="pxl--counter-value" data-duration="2000" data-to-value="<?php echo esc_attr($settings['number']); ?>" data-delimiter="">1</span>
                    <span class="pxl--counter-suffix"><?php echo pxl_print_html($settings['suffix']); ?></span>
                </span>
            <?php endif; ?>
            <div class="pxl-item--title"><?php echo pxl_print_html($settings['title']); ?></div>
        </div>
        <?php if(!empty($settings['rating_rate'])) :
            $thumbnail_url = '';
            if(!empty($settings['rating_rate_image']['id'])) {
                $img  = pxl_get_image_by_size( array(
                    'attach_id'  => $settings['rating_rate_image']['id'],
                    'thumb_size' => 'full',
                    'class' => 'no-lazyload'
                ) );
                $thumbnail_url    = $img['url'];
            } ?>
            <div class="pxl-item--rate">
                <span class="text-gradient" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);"><?php echo esc_attr($settings['rating_rate']); ?></span>
                <span>/</span>
                <span>5</span>
            </div>
        <?php endif; ?>
    </div>
</div>