<?php if(!empty($settings['banner_image']['id'])) : 
	$image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full'; 
	$img = pxl_get_image_by_size( array(
		'attach_id'  => $settings['banner_image']['id'],
		'thumb_size' => 'full',
	));
	$thumbnail = $img['url'];
endif;

if ( ! empty( $settings['item_link']['url'] ) ) {
	$widget->add_render_attribute( 'item_link', 'href', $settings['item_link']['url'] );

	if ( $settings['item_link']['is_external'] ) {
		$widget->add_render_attribute( 'item_link', 'target', '_blank' );
	}

	if ( $settings['item_link']['nofollow'] ) {
		$widget->add_render_attribute( 'item_link', 'rel', 'nofollow' );
	} ?>

<?php } ?>

<div class="pxl-banner pxl-banner2">
	<div class="pxl-banner-inner" style="background-image: url('<?php echo esc_url($thumbnail); ?>')">
		<?php if(!empty($settings['banner_title'])) : ?>
			<h4 class="pxl-banner-title"><?php echo pxl_print_html($settings['banner_title']); ?></h4>
			<span class="pxl-banner-desc"><?php echo pxl_print_html($settings['banner_desc']); ?></span>
			<a class="btn <?php echo pxl_print_html($settings['btn_style'].' '.$settings['btn_width']); ?>" <?php pxl_print_html($widget->get_render_attribute_string( 'item_link' )); ?>>
				<span class="pxl--btn-text" data-text="<?php echo esc_attr($settings['button_text']); ?>">
					<?php if($settings['btn_style'] == 'btn-nanuk' || $settings['btn_style'] == 'btn-nina') {
						$chars = str_split($settings['button_text']);
						foreach ($chars as $value) {
							if($value == ' ') {
								echo '<span class="spacer">&nbsp;</span>';
							} else {
								echo '<span>'.$value.'</span>';
							}
						}
					} else {
						echo pxl_print_html($settings['button_text']);
					} ?>
				</span>

			</a>
		<?php endif; ?>
	</div>
</div>