<?php
$active = intval($settings['active']);
$accordion = $widget->get_settings('accordion');
$wg_id = pxl_get_element_id($settings);
if(!empty($accordion)) : ?>
    <div class="pxl-accordion-wrap <?php if($settings['box_style'] == 'box-style1') { echo 'box-style1'; } ?>">
        <div class="pxl-accordion pxl-accordion1 <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
            <?php foreach ($accordion as $key => $value):
                $is_active = ($key + 1) == $active;
                $pxl_id = isset($value['_id']) ? $value['_id'] : '';
                $title = isset($value['title']) ? $value['title'] : '';
                $desc = isset($value['desc']) ? $value['desc'] : '';
                $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
                $widget->add_render_attribute( $icon_key, [
                    'class' => $value['pxl_icon'],
                    'aria-hidden' => 'true',
                ] ); ?>
                <div class="pxl--item <?php echo esc_attr($is_active ? 'active' : ''); ?>">
                    <<?php pxl_print_html($settings['title_tag']); ?> class="pxl-item--title" data-target="<?php echo esc_attr('#'.$wg_id.'-'.$pxl_id); ?>">
                    <?php if ( ! empty( $value['pxl_icon']['value'] ) ) : ?>
                        <span class="pxl-title--icon">
                            <?php \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
                    <?php endif; ?>
                    <span class="pxl-title--text"><?php echo wp_kses_post($title); ?></span>
                    <?php if($settings['style'] == 'style1') : ?><i class="pxl-icon--plus"></i><?php endif; ?>
                    </<?php pxl_print_html($settings['title_tag']); ?>>
                    <div id="<?php echo esc_attr($wg_id.'-'.$pxl_id); ?>" class="pxl-item--content" <?php if($is_active){ ?>style="display: block;"<?php } ?>><?php echo wp_kses_post(nl2br($desc)); ?></div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php if($settings['box_style'] == 'box-style1'): ?>
            <div class="pxl-accordion-bottom">
                <div class="pxl-box--subtitle el-empty"><?php echo esc_attr($settings['wg_sub_title']); ?></div>
                <div class="pxl-box--title">
                    <?php echo esc_attr($settings['wg_title']); ?>
                    <?php if(!empty($settings['wg_btn_text'])) : 
                        if ( ! empty( $settings['wg_btn_link']['url'] ) ) {
                            $widget->add_render_attribute( 'button', 'href', $settings['wg_btn_link']['url'] );

                            if ( $settings['wg_btn_link']['is_external'] ) {
                                $widget->add_render_attribute( 'button', 'target', '_blank' );
                            }

                            if ( $settings['wg_btn_link']['nofollow'] ) {
                                $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
                            }
                        } ?>
                        <a <?php pxl_print_html($widget->get_render_attribute_string( 'button' )); ?>><?php echo esc_attr($settings['wg_btn_text']); ?></a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
