<?php 

if(!function_exists('immigway_get_post_grid')){
    function immigway_get_post_grid($posts = [], $settings = []){ 
        if (empty($posts) || !is_array($posts) || empty($settings) || !is_array($settings)) {
            return false;
        }
        switch ($settings['layout']) {
            case 'post-1':
            immigway_get_post_grid_layout1($posts, $settings);
            break;

            case 'post-2':
            immigway_get_post_grid_layout2($posts, $settings);
            break;

            case 'careers-1':
            immigway_get_careers_grid_layout1($posts, $settings);
            break;

            case 'visa-1':
            immigway_get_visa_grid_layout1($posts, $settings);
            break;

            case 'country-1':
            immigway_get_country_grid_layout1($posts, $settings);
            break;

            case 'case-studies-1':
            immigway_get_case_studies_grid_layout1($posts, $settings);
            break;

            case 'case-studies-2':
            immigway_get_case_studies_grid_layout2($posts, $settings);
            break;

            case 'service-1':
            immigway_get_service_grid_layout1($posts, $settings);
            break;

            case 'service-2':
            immigway_get_service_grid_layout2($posts, $settings);
            break;

            case 'service-3':
            immigway_get_service_grid_layout3($posts, $settings);
            break;

            case 'service-4':
            immigway_get_service_grid_layout4($posts, $settings);
            break;

            default:
            return false;
            break;
        }
    }
}

// Start Post Grid
//--------------------------------------------------
function immigway_get_post_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '740x474';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $author = get_user_by('id', $post->post_author);  ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                    <div class="pxl-item--featured">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                    </div>
                <?php endif; ?>
                <?php if($show_author == 'true' || $show_date == 'true' ) : ?>
                    <div class="pxl-item--meta">
                        <?php if($show_date == 'true'): ?>
                            <div class="pxl-item--date pxl-date--box pxl-r-0"><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?></div>
                        <?php endif; ?>
                        <?php $author = get_user_by('id', $post->post_author);
                        $author_avatar = get_avatar( $post->post_author, 60, '', $author->display_name, array( 'class' => '' ) );
                        $user_position = get_user_meta($post->post_author, 'user_position', true); ?>
                        <div class="pxl-item--author pxl-author--box">
                            <?php if(!empty($author_avatar)) : ?>
                                <div class="pxl-auhtor--img pxl-mr-12">
                                    <?php pxl_print_html($author_avatar); ?>
                                </div>
                            <?php endif; ?>
                            <div class="pxl-auhtor--meta">
                                <h6><?php the_author_posts_link(); ?></h6>
                                <?php if(!empty($user_position)) { ?>
                                    <div class="pxl-auhtor--position">
                                        <?php echo esc_attr($user_position); ?>
                                    </div>
                                <?php } ?>   
                            </div>     
                        </div>
                    </div>
                <?php endif; ?>
                <div class="pxl-item--holder">
                    <h5 class="pxl-item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h5>
                    <?php if($show_excerpt == 'true'): ?>
                        <div class="pxl-item--content pxl-sz-content pxl-excerpt-line" style="-webkit-line-clamp: <?php echo esc_attr($line_words); ?>;">
                            <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if($show_button == 'true') : ?>
                        <div class="pxl-item--button">
                            <a class="btn--readmore" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                
                                <span class="btn-readmore--text"><?php if(!empty($button_text)) {
                                    echo esc_attr($button_text);
                                } else {
                                    echo esc_html__('Read Article', 'immigway');
                                } ?></span>
                                <span class="btn-readmore--icon pxl-ml-10"><i class="flaticon-right-arrow-2 rtl-reverse"></i></span>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    endforeach;
endif;
}

function immigway_get_post_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '740x474';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            $author = get_user_by('id', $post->post_author);  ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                    <div class="pxl-item--featured">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) { $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>style="background-image: url(<?php echo esc_url($thumbnail_url[0]); ?>);"<?php } ?>><?php echo wp_kses_post($thumbnail); ?></a>
                    </div>
                <?php endif; ?>
                <div class="pxl-item--holder">
                    <?php if($show_comment_count == 'true' || $show_date == 'true' ) : ?>
                        <div class="pxl-item--meta">
                            <?php if($show_date == 'true'): ?>
                                <div class="pxl-item--date pxl-date--box pxl-r-0"><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $post->ID); ?></div>
                            <?php endif; ?>
                            <?php if($show_comment_count == 'true'): ?>
                                <div class="pxl-item-comment">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>#comments"><?php echo comments_number(esc_html__('0', 'immigway'), esc_html__('1', 'immigway'), esc_html__('%', 'immigway'), $post->ID); ?></a>
                                </div>
                            <?php endif; ?>                           
                        </div>
                    <?php endif; ?>
                    <h5 class="pxl-item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h5>
                    <?php if($show_excerpt == 'true'): ?>
                        <div class="pxl-item--content pxl-sz-content pxl-excerpt-line" style="-webkit-line-clamp: <?php echo esc_attr($line_words); ?>;">
                            <?php echo wp_trim_words( $post->post_excerpt, $num_words, $more = null ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if($show_button == 'true') : ?>
                        <div class="pxl-item--button">
                            <a class="btn--readmore" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                <span class="btn-readmore--text"><?php if(!empty($button_text)) {
                                    echo esc_attr($button_text);
                                } else {
                                    echo esc_html__('View More', 'immigway');
                                } ?></span>
                                <span class="btn-readmore--icon pxl-ml-10"><i class="flaticon-right-arrow-2 rtl-reverse"></i></span>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    endforeach;
endif;
}
// End Post Grid
//--------------------------------------------------

// Start Visa Grid
//--------------------------------------------------
function immigway_get_visa_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '420x511';
    $count = 0;
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $count++;
            $visa_icon_type = get_post_meta($post->ID, 'visa_icon_type', true);
            $visa_icon_font = get_post_meta($post->ID, 'visa_icon_font', true);
            $visa_icon_img = get_post_meta($post->ID, 'visa_icon_img', true);
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                    <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" title="<?php echo esc_attr(get_the_title($post->ID)); ?>"></a>
                        <div class="pxl-item--featured">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </div>
                        <div class="pxl-item--holder">
                            <?php if($show_button == 'true') : ?>
                                <i class="caseicon-long-arrow-right-three icon-readmore"></i>
                            <?php endif; ?>
                            <div class="pxl-item--meta">  
                               <?php if($visa_icon_type == 'icon' && !empty($visa_icon_font)) : ?>
                                <div class="pxl-item--icon">
                                    <i class="<?php echo esc_attr($visa_icon_font); ?>"></i>
                                </div>
                            <?php endif; ?>
                            <?php if($visa_icon_type == 'image' && !empty($visa_icon_img)) : 
                                $icon_img = pxl_get_image_by_size( array(
                                    'attach_id'  => $visa_icon_img['id'],
                                    'thumb_size' => 'full',
                                ));
                                $icon_thumbnail = $icon_img['thumbnail'];
                                ?>
                                <div class="pxl-item--icon">
                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                </div>
                            <?php endif; ?>
                            <div class="pxl-wrap-content">
                                <span class="pxl-visa-count">
                                    Service <?php echo pxl_print_html($count); ?>
                                </span>
                                <h3 class="pxl-item--title"><?php echo esc_attr(get_the_title($post->ID)); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
    endforeach;
endif;
}

// End Vísa Grid
//--------------------------------------------------

// Start Careers Grid
//--------------------------------------------------
function immigway_get_careers_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '420x320';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $careers_excerpt = get_post_meta($post->ID, 'careers_excerpt', true);
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            }
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <a class="pxl-wrap-link" href="<?php echo esc_url(get_permalink( $post->ID )); ?>" title="<?php echo esc_attr(get_the_title($post->ID)); ?>"></a>
                    <div class="pxl-item--featured">
                       <?php echo wp_kses_post($thumbnail); ?>
                    </div>
                   <div class="pxl-item--holder">
                    <?php if($show_date == 'true' ) : ?>
                        <span class="pxl-item--date"><?php echo esc_attr(get_the_date('j F, Y')); ?></span>
                    <?php endif; ?>
                    <h3 class="pxl-item--title"><?php echo esc_attr(get_the_title($post->ID)); ?></h3>
                    <?php if($show_excerpt == 'true' && !empty($careers_excerpt)): ?>
                        <div class="pxl-item--content pxl-excerpt-line" style="-webkit-line-clamp: <?php echo esc_attr($line_words); ?>;">
                            <?php echo wp_trim_words( $careers_excerpt, $num_words, $more = null ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if($show_button == 'true') : ?>
                        <a class="pxl-button-link" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                          <span class="btn-readmore--text">
                            <?php if(!empty($button_text)) {
                                echo esc_attr($button_text);
                            } else {
                                echo esc_html__('Apply Here', 'immigway');
                            } ?>
                        </span>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php
endforeach;
endif;
}


// End Careers Grid
//--------------------------------------------------

// Start Country Grid
//--------------------------------------------------
function immigway_get_country_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '59x59';
    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $icon_multi_text = get_post_meta($post->ID, 'icon_multi_text', true);
            $multi_text_country = get_post_meta($post->ID, 'multi_text_country', true);
            $custom_text_buy_grid = get_post_meta($post->ID, 'custom_text_buy_grid', true);
            $custom_text_link = get_post_meta($post->ID, 'custom_text_link', true);
            $count_li = 0;
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload image-flag',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                    <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">

                        <div class="pxl-item-meta">
                            <div class="wrap-image-flag">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </div>
                            <div class="wrap-info">
                                <a href="<?php if(!empty($custom_text_link)) { echo esc_url($custom_text_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>" class="text-visa-service"><?php echo pxl_print_html($custom_text_buy_grid); ?></a>
                                <h3 class="pxl-item--title"><?php echo esc_attr(get_the_title($post->ID)); ?></h3>
                            </div>
                        </div>
                        <div class="pxl-item--holder">
                            <?php if (!empty($multi_text_country)): ?>
                                <ul class="multi-text">
                                    <?php foreach ($multi_text_country as $text): 
                                        $count_li++;
                                        ?>

                                        <li class="box-multi">
                                            <i class="<?php echo esc_attr($icon_multi_text); ?>"></i>
                                            <p><?php echo pxl_print_html($text); ?></p>
                                        </li>
                                        <?php if($count_li == $number_multi){
                                            break;
                                        }?>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                            <?php if($show_button == 'true') : ?>
                                <a class="btn btn-full-width-icon-absolute" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                    <span class="btn-readmore--text"><?php if(!empty($button_text)) {
                                        echo esc_attr($button_text);
                                    } else {
                                        echo esc_html__('Read More', 'immigway');
                                    } ?></span>
                                    <i class="caseicon-long-arrow-right-three icon-readmore"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php
        endforeach;
    endif;
}

// End Country Grid
//--------------------------------------------------

// Start Case Studies Grid
//--------------------------------------------------
function immigway_get_case_studies_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '425x425';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                    <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                        <div class="pxl-effect--direction">
                            <div class="pxl-item--featured">
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" title="<?php echo esc_attr(get_the_title($post->ID)); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                            </div>
                            <div class="pxl-item--holder pxl-effect--content">
                                <div class="pxl-item--shape1 bg-image"></div>
                                <div class="pxl-item--shape2 bg-image"></div>
                                <div class="pxl-item--meta">
                                    <h3 class="pxl-item--title"><?php echo esc_attr(get_the_title($post->ID)); ?></h3>
                                    <div class="pxl-item--divider"></div>
                                    <?php if($show_category == 'true'): ?>
                                        <div class="pxl-item--category">
                                            <?php the_terms( $post->ID, 'case-studies-category', '', ' ' ); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <a class="pxl-item--link" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"></a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php
        endforeach;
    endif;
}

function immigway_get_case_studies_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '600x600';

    if (is_array($posts)):
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $img_id = get_post_thumbnail_id($post->ID);
            if($img_id) {
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $img_id,
                    'thumb_size' => $images_size,
                    'class' => 'no-lazyload',
                ));
                $thumbnail = $img['thumbnail'];
            } else {
                $thumbnail = get_the_post_thumbnail($post->ID, $images_size);
            } 
            if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                    <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                        <div class="pxl-item--featured">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>" title="<?php echo esc_attr(get_the_title($post->ID)); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                        </div>
                        <div class="pxl-flip--box">
                            <div class="pxl-item--holder pxl-item--front">
                                <h6 class="pxl-item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h6>
                                <?php if($show_category == 'true'): ?>
                                    <div class="pxl-item--category">
                                        <?php the_terms( $post->ID, 'case-studies-category', '', ' ' ); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="pxl-item--holder pxl-item--back">
                                <h6 class="pxl-item--title"><a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a></h6>
                                <?php if($show_category == 'true'): ?>
                                    <div class="pxl-item--category">
                                        <?php the_terms( $post->ID, 'case-studies-category', '', ' ' ); ?>
                                    </div>
                                <?php endif; ?>
                                <a class="pxl-item--readmore pxl-r-10" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><i class="flaticon-right-arrow-2"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php
        endforeach;
    endif;
}
// End Case Studies Grid
//--------------------------------------------------

// Start Service Grid
//--------------------------------------------------
function immigway_get_service_grid_layout1($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '380x380';

    if (is_array($posts)):
        $last_key = array_key_last($posts);
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if($style_service_l1 == 'style-3') : ?>
                        <div class="pxl-item--shape2 pxl-item--shape-primary">
                            <div class="pxl-shape--divider pxl-shape--divider1"></div>
                            <div class="pxl-shape--divider pxl-shape--divider2"></div>
                            <div class="pxl-shape--divider pxl-shape--divider3"></div>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-item--main">
                        <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                        $img_id       = get_post_thumbnail_id( $post->ID );
                        $img          = immigway_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail_url    = $img['url']; ?>
                        <div class="pxl-item--featured bg-image" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);">
                            <div class="pxl-item--shape2 pxl-item--shape-secondary">
                                <div class="pxl-shape--divider pxl-shape--divider1"></div>
                                <div class="pxl-shape--divider pxl-shape--divider2"></div>
                                <div class="pxl-shape--divider pxl-shape--divider3"></div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-item--holder">
                        <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                            <div class="pxl-item--icon">
                                <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                            </div>
                        <?php endif; ?>
                        <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                            $icon_img = pxl_get_image_by_size( array(
                                'attach_id'  => $service_icon_img['id'],
                                'thumb_size' => 'full',
                            ));
                            $icon_thumbnail = $icon_img['thumbnail'];
                            ?>
                            <div class="pxl-item--icon">
                                <?php echo wp_kses_post($icon_thumbnail); ?>
                            </div>
                        <?php endif; ?>
                        <h3 class="pxl-item--title">
                            <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                        </h3>
                        <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                            <div class="pxl-item--content pxl-excerpt-line" style="-webkit-line-clamp: <?php echo esc_attr($line_words); ?>;">
                                <?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?>
                            </div>
                        <?php endif; ?>
                        <?php if($show_button == 'true') : ?>
                            <div class="pxl-item--readmore">
                                <a class="btn--readmore2" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                    <span class="btn-readmore--icon pxl-mr-10"><i class="flaticon-right-arrow-2 rtl-reverse"></i></span>
                                    <span class="btn-readmore--text"><?php if(!empty($button_text)) {
                                        echo esc_attr($button_text);
                                    } else {
                                        echo esc_html__('Read more', 'immigway');
                                    } ?></span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="pxl-item--shape">
                        <div class="pxl-shape--divider pxl-shape--divider1"></div>
                        <div class="pxl-shape--divider pxl-shape--divider2"></div>
                        <div class="pxl-shape--divider pxl-shape--divider3"></div>
                    </div>
                </div>
            </div>
        </div>
        <?php if ($key == $last_key && !empty($h_title)) : ?>
            <div class="pxl-item--last <?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <div class="pxl-item--main">
                        <div class="pxl-item--holder">
                            <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                                <div class="pxl-item--icon">
                                    <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                                </div>
                            <?php endif; ?>
                            <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                                $icon_img = pxl_get_image_by_size( array(
                                    'attach_id'  => $service_icon_img['id'],
                                    'thumb_size' => 'full',
                                ));
                                $icon_thumbnail = $icon_img['thumbnail'];
                                ?>
                                <div class="pxl-item--icon">
                                    <?php echo wp_kses_post($icon_thumbnail); ?>
                                </div>
                            <?php endif; ?>
                            <h3 class="pxl-item--title">
                                <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                            </h3>
                            <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                                <div class="pxl-item--content">
                                    <?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if($show_button == 'true') : ?>
                                <div class="pxl-item--readmore">
                                    <a class="btn--readmore2" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                                        <span class="btn-readmore--icon pxl-mr-10"><i class="flaticon-right-arrow-2 rtl-reverse"></i></span>
                                        <span class="btn-readmore--text"><?php if(!empty($button_text)) {
                                            echo esc_attr($button_text);
                                        } else {
                                            echo esc_html__('View more', 'immigway');
                                        } ?></span>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="pxl-item--wg">
                        <?php if(!empty($box_image['id'])) : 
                            $img = pxl_get_image_by_size( array(
                                'attach_id'  => $box_image['id'],
                                'thumb_size' => 'full',
                            ));
                            $thumbnail = $img['url']; ?>
                            <div class="pxl-wg--image bg-image" style="background-image: url(<?php echo esc_url($thumbnail); ?>);"></div>
                        <?php endif; ?>
                        <h3 class="pxl-wg--title"><?php echo esc_attr($h_title); ?></h3>
                        <?php if(!empty($h_btn_text)) : ?>
                            <div class="pxl-wg--button">
                                <a href="<?php echo esc_url($h_btn_link['url']); ?>" class="btn btn-default btn-white">
                                    <span class="pxl--btn-text" data-text="<?php echo esc_attr($h_btn_text); ?>">
                                        <?php echo pxl_print_html($h_btn_text); ?>
                                    </span>
                                    <span class="pxl--text-wrap">
                                        <span class="pxl--btn-text1"><?php echo pxl_print_html($h_btn_text); ?></span>
                                        <span class="pxl--btn-text2"><?php echo pxl_print_html($h_btn_text); ?></span>
                                    </span>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>
<?php endif;
}
function immigway_get_service_grid_layout2($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '410x270';

    if (is_array($posts)):
        $last_key = array_key_last($posts);
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                    $img_id       = get_post_thumbnail_id( $post->ID );
                    $img          = immigway_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size
                    ) );
                    $thumbnail_url    = $img['thumbnail']; ?>
                    <div class="pxl-item--featured item-image">
                        <a class="pxl-wrap-link" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"> <?php echo wp_kses_post($thumbnail_url); ?></a>
                    </div>
                <?php endif; ?>
                <div class="pxl-item--holder">
                   <?php if ($service_icon_type == 'icon' && !empty($service_icon_font)): ?>
                    <div class="pxl-item--icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                            <path d="M0 9C6 9 8.5 3 9 0V9H0Z"/>
                        </svg>
                        <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                        <svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                            <path d="M9 9C3 9 0.5 3 0 0V9H9Z"/>
                        </svg>
                    </div>
                <?php endif; ?>
                <?php if ($service_icon_type == 'image' && !empty($service_icon_img)): 
                    $icon_img = pxl_get_image_by_size( array(
                        'attach_id'  => $service_icon_img['id'],
                        'thumb_size' => 'full',
                    ));
                    $icon_thumbnail = $icon_img['thumbnail'];
                    ?>
                    <div class="pxl-item--icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                            <path d="M0 9C6 9 8.5 3 9 0V9H0Z"/>
                        </svg>
                        <?php echo wp_kses_post($icon_thumbnail); ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="9" height="9" viewBox="0 0 9 9" fill="none">
                            <path d="M9 9C3 9 0.5 3 0 0V9H9Z"/>
                        </svg>
                    </div>
                <?php endif; ?>
                <h3 class="pxl-item--title">
                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                </h3>
                <div class="pxl-line-paper">

                </div>
                <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                    <div class="pxl-item--content pxl-excerpt-line" style="-webkit-line-clamp: <?php echo esc_attr($line_words); ?>;">
                        <?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?>
                    </div>
                <?php endif; ?>
                <?php if($show_button == 'true') : ?>
                    <div class="pxl-item--button">
                        <a class="btn--readmore" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                            <span class="btn-readmore--text"><?php if(!empty($button_text)) {
                                echo esc_attr($button_text);
                            } else {
                                echo esc_html__('View More', 'immigway');
                            } ?></span>
                            <span class="btn-readmore--icon pxl-ml-10"><i class="flaticon-right-arrow-2 rtl-reverse"></i></span>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endforeach; ?>
<?php endif;
}

function immigway_get_service_grid_layout3($posts = [], $settings = []){ 
    extract($settings);
    
    $images_size = !empty($img_size) ? $img_size : '433x426';

    if (is_array($posts)):
        $last_key = array_key_last($posts);
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
            $service_icon_type = get_post_meta($post->ID, 'service_icon_type', true);
            $service_icon_font = get_post_meta($post->ID, 'service_icon_font', true);
            $service_icon_img = get_post_meta($post->ID, 'service_icon_img', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                    $img_id       = get_post_thumbnail_id( $post->ID );
                    $img          = immigway_get_image_by_size( array(
                        'attach_id'  => $img_id,
                        'thumb_size' => $images_size
                    ) );
                    $thumbnail_url    = $img['thumbnail']; ?>
                    <div class="pxl-item--featured item-image">
                        <a class="pxl-wrap-link" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"> <?php echo wp_kses_post($thumbnail_url); ?></a>
                    </div>
                <?php endif; ?>
                <div class="pxl-item--holder">
                    <?php if($service_icon_type == 'icon' && !empty($service_icon_font)) : ?>
                        <div class="pxl-item--icon">
                            <i class="<?php echo esc_attr($service_icon_font); ?>"></i>
                        </div>
                    <?php endif; ?>
                    <?php if($service_icon_type == 'image' && !empty($service_icon_img)) : 
                        $icon_img = pxl_get_image_by_size( array(
                            'attach_id'  => $service_icon_img['id'],
                            'thumb_size' => 'full',
                        ));
                        $icon_thumbnail = $icon_img['thumbnail'];
                        ?>
                        <div class="pxl-item--icon">
                            <?php echo wp_kses_post($icon_thumbnail); ?>
                        </div>
                    <?php endif; ?>
                    <?php if($show_category == 'true'): ?>
                        <div class="pxl-item--category">
                            <?php the_terms( $post->ID, 'service-category', '', ' ' ); ?>
                        </div>
                    <?php endif; ?>
                    <h3 class="pxl-item--title">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                    </h3>
                    <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                        <div class="pxl-item--content pxl-excerpt-line" style="-webkit-line-clamp: <?php echo esc_attr($line_words); ?>;">
                            <?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if($show_button == 'true') : ?>
                        <a class="btn btn-full-width-icon-absolute" href="<?php echo esc_url(get_permalink( $post->ID )); ?>">
                            <span class="btn-readmore--text"><?php if(!empty($button_text)) {
                                echo esc_attr($button_text);
                            } else {
                                echo esc_html__('View More', 'immigway');
                            } ?></span>
                            <span class="btn-readmore--icon pxl-ml-10"><i class="flaticon-right-arrow-2 rtl-reverse"></i></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
<?php endif;
}

function immigway_get_service_grid_layout4($posts = [], $settings = []){ //phap
    extract($settings);
    $images_size = !empty($img_size) ? $img_size : '400x280';

    if (is_array($posts)):
        $last_key = array_key_last($posts);
        foreach ($posts as $key => $post):
            $item_class = "pxl-grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
            if(isset($grid_masonry) && !empty($grid_masonry[$key]) && (count($grid_masonry) > 1)) {
                if($grid_masonry[$key]['col_xl_m'] == '5') {
                    $col_xl_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_xl_m'] == 'col-40') {
                    $col_xl_m = '40-pxl';
                } else {
                    $col_xl_m = 12 / $grid_masonry[$key]['col_xl_m'];
                }
                if($grid_masonry[$key]['col_lg_m'] == '5') {
                    $col_lg_m = '20-pxl';
                } elseif($grid_masonry[$key]['col_lg_m'] == 'col-40') {
                    $col_lg_m = '40-pxl';
                } else {
                    $col_lg_m = 12 / $grid_masonry[$key]['col_lg_m'];
                }
                $col_md_m = 12 / $grid_masonry[$key]['col_md_m'];
                $col_sm_m = 12 / $grid_masonry[$key]['col_sm_m'];
                $col_xs_m = 12 / $grid_masonry[$key]['col_xs_m'];
                $item_class = "pxl-grid-item col-xl-{$col_xl_m} col-lg-{$col_lg_m} col-md-{$col_md_m} col-sm-{$col_sm_m} col-{$col_xs_m}";
                
                $img_size_m = $grid_masonry[$key]['img_size_m'];
                if(!empty($img_size_m)) {
                    $images_size = $img_size_m;
                }
            } elseif (!empty($img_size)) {
                $images_size = $img_size;
            }

            if(!empty($tax))
                $filter_class = pxl_get_term_of_post_to_class($post->ID, array_unique($tax));
            else 
                $filter_class = '';

            $service_excerpt = get_post_meta($post->ID, 'service_excerpt', true);
            $icon_multi_text_service = get_post_meta($post->ID, 'icon_multi_text_service', true);
            $multi_text_service = get_post_meta($post->ID, 'multi_text_service', true);
            $service_price = get_post_meta($post->ID, 'service_price', true);
            $service_price_for = get_post_meta($post->ID, 'service_price_for', true);
            $service_external_link = get_post_meta($post->ID, 'service_external_link', true);
            ?>
            <div class="<?php echo esc_attr($item_class . ' ' . $filter_class); ?>">
                <div class="pxl-item--inner <?php echo esc_attr($pxl_animate); ?>" data-wow-duration="1.2s">
                    <div class="wrap-content">
                        <div class="pxl-wrap-left">
                            <?php if($show_category == 'true'): ?>
                                <div class="pxl-item--category">
                                    <?php the_terms( $post->ID, 'service-category', '', ' ' ); ?>
                                </div>
                            <?php endif; ?>
                            <h3 class="pxl-item--title">
                                <a href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php echo esc_attr(get_the_title($post->ID)); ?></a>
                            </h3>
                            <?php if($show_excerpt == 'true' && !empty($service_excerpt)): ?>
                                <div class="pxl-item--content pxl-excerpt-line" style="-webkit-line-clamp: <?php echo esc_attr($line_words); ?>;">
                                    <?php echo wp_trim_words( $service_excerpt, $num_words, $more = null ); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                        $img_id       = get_post_thumbnail_id( $post->ID );
                        $img          = immigway_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $images_size
                        ) );
                        $thumbnail_url    = $img['thumbnail']; ?>
                        <div class="pxl-item--featured item-image">
                            <a class="pxl-wrap-link" href="<?php echo esc_url(get_permalink( $post->ID )); ?>"> <?php echo wp_kses_post($thumbnail_url); ?></a>
                        </div>
                    <?php endif; ?>
                    
                </div>
                <div class="wrap-right">
                   <?php if (!empty($multi_text_service)): ?>
                    <ul class="multi-text">
                        <?php foreach ($multi_text_service as $text): ?>
                            <li class="box-multi">
                                <i class="<?php echo esc_attr($icon_multi_text_service); ?>"></i>
                                <p><?php echo pxl_print_html($text); ?></p>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
                <div class="pxl-item--price">
                    <?php if($service_price) : ?>
                        <span class="pxl-service-price"><?php echo esc_attr($service_price); ?></span>
                        <?php if($service_price_for) : ?>
                            <span class="pxl-service-price-for"><?php echo esc_attr($service_price_for); ?></span>
                        <?php endif ?>
                    <?php endif; ?>
                    <?php if($show_button) : ?>
                        <a class="btn btn-primary" href="<?php if(!empty($service_external_link)) { echo esc_url($service_external_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                            <span class="btn-readmore--text"><?php if(!empty($button_text)) {
                                echo esc_attr($button_text);
                            } else {
                                echo esc_html__('Get Started', 'immigway');
                            } ?></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            
        </div>
    </div>
<?php endforeach; ?>
<?php endif;
}

// End Service Grid
//-------------------------------------------------

add_action( 'wp_ajax_immigway_get_pagination_html', 'immigway_get_pagination_html' );
add_action( 'wp_ajax_nopriv_immigway_get_pagination_html', 'immigway_get_pagination_html' );
function immigway_get_pagination_html(){
    try{
        if(!isset($_POST['query_vars'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'immigway'));
        }
        $query = new WP_Query($_POST['query_vars']);
        ob_start();
        immigway()->page->get_pagination( $query,  true );
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'immigway'),
                'data' => array(
                    'html' => $html,
                    'query_vars' => $_POST['query_vars'],
                    'post' => $query->have_posts()
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_immigway_load_more_post_grid', 'immigway_load_more_post_grid' );
add_action( 'wp_ajax_nopriv_immigway_load_more_post_grid', 'immigway_load_more_post_grid' );
function immigway_load_more_post_grid(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'immigway'));
        }
        $settings = $_POST['settings'];
        set_query_var('paged', $settings['paged']);
        extract(pxl_get_posts_of_grid($settings['post_type'], [
            'source' => isset($settings['source'])?$settings['source']:'',
            'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
            'order' => isset($settings['order'])?$settings['order']:'desc',
            'limit' => isset($settings['limit'])?$settings['limit']:'6',
            'post_ids' => isset($settings['post_ids'])?$settings['post_ids']:[],
        ]));
        ob_start();

        immigway_get_post_grid($posts, $settings);
        $html = ob_get_clean();
        wp_send_json(
            array(
                'status' => true,
                'message' => esc_attr__('Load Successfully!', 'immigway'),
                'data' => array(
                    'html' => $html,
                    'paged' => $settings['paged'],
                    'posts' => $posts,
                    'max' => $max,
                ),
            )
        );
    }
    catch (Exception $e){
        wp_send_json(array('status' => false, 'message' => $e->getMessage()));
    }
    die;
}

add_action( 'wp_ajax_immigway_get_filter_html', 'immigway_get_filter_html' );
add_action( 'wp_ajax_nopriv_immigway_get_filter_html', 'immigway_get_filter_html' );
function immigway_get_filter_html(){
    try{
        if(!isset($_POST['settings'])){
            throw new Exception(__('Something went wrong while requesting. Please try again!', 'immigway'));
        }
        $settings = $_POST['settings'];
        $loadmore_filter = $_POST['loadmore_filter'];
        if($loadmore_filter == '1'){
            set_query_var('paged', 1);
            $limit = isset($settings['limit'])?$settings['limit']:'6';
            $limitx = (int)$limit * (int)$settings['paged'];
        }else{
            set_query_var('paged', $settings['paged']);
            $limitx = isset($settings['limit'])?$settings['limit']:'6';
        }
        extract(pxl_get_posts_of_grid($settings['post_type'], [
            'source' => isset($settings['source'])?$settings['source']:'',
            'orderby' => isset($settings['orderby'])?$settings['orderby']:'date',
            'order' => isset($settings['order'])?$settings['order']:'desc',
            'limit' => $limitx,
            'post_ids' => isset($settings['post_ids'])?$settings['post_ids']: [],
        ],
        $settings['tax']
    ));
    ob_start(); ?>

    <span class="filter-item active" data-filter="*">
        <?php echo esc_html($settings['filter_default_title']); ?>
        <?php if($settings['show_cat_count'] == '1'): ?>
            <span class="filter-item-count"><?php echo count($posts); ?></span> 
        <?php endif; ?>
    </span>
    <?php foreach ($categories as $category):
        $category_arr = explode('|', $category);
        $term = get_term_by('slug',$category_arr[0], $category_arr[1]);
        $tax_count = 0;
        foreach ($posts as $key => $post){
            $this_terms = get_the_terms( $post->ID,  $settings['tax'][0] );
            $term_list = [];
            foreach ($this_terms as $t) {
                $term_list[] = $t->slug;
            } 
            if(in_array($term->slug,$term_list))
                $tax_count++;
        } 
        if($tax_count > 0): ?>
            <span class="filter-item" data-filter="<?php echo esc_attr('.' . $term->slug); ?>">
                <?php echo esc_html($term->name); ?>
                <?php if($settings['show_cat_count'] == '1'): ?>
                    <span class="filter-item-count"><?php echo esc_attr($tax_count); ?></span> 
                <?php endif; ?>
            </span>
        <?php endif; ?>
    <?php endforeach; ?>

    <?php $html = ob_get_clean();
    wp_send_json(
        array(
            'status' => true,
            'message' => esc_attr__('Load Successfully!', 'immigway'),
            'data' => array(
                'html' => $html,
                'paged' => $settings['paged'],
                'posts' => $posts,
                'max' => $max,
            ),
        )
    );
}
catch (Exception $e){
    wp_send_json(array('status' => false, 'message' => $e->getMessage()));
}
die;
}

function immigway_user_form() {
    if(function_exists('up_get_template_part') && !is_user_logged_in()) : ?>
        <div class="pxl-modal pxl-user-popup">
            <div class="pxl-modal-close"><i class="pxl-icon-close"></i></div>
            <div class="pxl-modal-content">
                <div class="pxl-user pxl-user-register u-close">
                    <div class="pxl-user-content">
                        <h3 class="pxl-user-heading"><?php echo esc_html__('Create your account', 'immigway'); ?></h3>
                        <?php echo do_shortcode('[bravis-user-form form_type="register"]'); ?>
                        <div class="pxl-user-footer">
                            <a href="javascript:void(0)" class="btn-sign-in"> <?php esc_html_e('Sign In', 'immigway');?></a>
                        </div>
                    </div>
                </div>
                <div class="pxl-user pxl-user-login">
                    <div class="pxl-user-content">
                        <h3 class="pxl-user-heading"><?php echo esc_html__('Log in to Your Account', 'immigway'); ?></h3>
                        <?php echo do_shortcode('[bravis-user-form form_type="login" is_logged="profile"]'); ?>  
                        <div class="pxl-user-footer">
                            <a href="javascript:void(0)" class="btn-sign-up"> <?php esc_html_e('Sign Up', 'immigway');?></a>
                        </div>
                        <?php if(class_exists('Woocommerce')) : 
                            $my_ac = get_option( 'woocommerce_myaccount_page_id' ); 
                            $lost_password = get_option( 'woocommerce_myaccount_lost_password_endpoint' );
                            ?>
                            <div class="pxl-user-forgot-pass"><a href="<?php echo esc_url(get_permalink($my_ac)); ?><?php echo esc_attr($lost_password); ?>"><?php esc_html_e('Forgot your password?', 'immigway');?></a></div>
                        <?php endif; ?>
                    </div>
                </div> 
            </div>
        </div>
    <?php endif;
}