<?php
/**
 * @package Bravis-Themes
 */
get_header(); ?>
<div class="container">
    <div class="row content-row">
        <div id="pxl-content-area" class="pxl-content-area col-12">
            <main id="pxl-content-main">
                <div class="pxl-error-inner">
                    <img src="<?php echo esc_url(get_template_directory_uri().'/assets/img/map.png'); ?>" alt="Map For 404 Page">
                    <div class="pxl-error-holder">
                        <div class="pxl-error-number">404</div>
                        <h3 class="pxl-error-title">
                            <?php echo esc_html__('Page Not Found', 'immigway'); ?>
                        </h3>
                        <div class="pxl-error-description"><?php echo esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'immigway'); ?></div>
                        <form role="search" method="get" class="search-form" action="<?php echo esc_url(home_url( '/' )); ?>">
                            <div class="searchform-wrap">
                                <input type="text" placeholder="<?php esc_attr_e('Search Here', 'immigway'); ?>" name="s" class="search-field" />
                                <button type="submit" class="search-submit"><i class="caseicon-search"></i></button>
                            </div>
                        </form>
                        <a class="btn btn-primary" href="<?php echo esc_url(home_url('/')); ?>">
                            <span class="pxl--btn-text"><?php echo esc_html__('Go Back Home', 'immigway'); ?></span>
                        </a>
                    </div>
                </div>
            </main>
        </div>
    </div>
</div>
<?php get_footer();
