<?php
/**
 * Template Name: Blog Listing
 * Description: Elementor-based blog template with Unlimited Elements and dynamic widget support.
 */

get_header();
\Elementor\Plugin::instance()->frontend->start_excerpt_flag();

// Enqueue custom styles for blog cards
defined('ABSPATH') || exit;
function enqueue_blog_card_styles() {
  wp_enqueue_style('hello-elementor-blog-card-style', get_stylesheet_directory_uri() . '/blog-card-style.css');
}
add_action('wp_enqueue_scripts', 'enqueue_blog_card_styles');
?>

<div class="elementor-container elementor-blog-wrapper">
  <div class="elementor-row">
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
      <div class="elementor-column elementor-col-33 blog-post">
        <div class="elementor-widget-container">
          <div class="blog-card">
            <a href="<?php the_permalink(); ?>">
              <?php if (has_post_thumbnail()) : ?>
                <div class="blog-thumbnail"> <?php the_post_thumbnail('medium'); ?> </div>
              <?php endif; ?>
              <h3 class="blog-title"><?php the_title(); ?></h3>
            </a>
            <p class="meta"><?php the_time('F j, Y'); ?> by <?php the_author(); ?></p>
            <div class="excerpt"> <?php the_excerpt(); ?> </div>
            <a href="<?php the_permalink(); ?>" class="read-more">Read More</a>
          </div>
        </div>
      </div>
    <?php endwhile; else : ?>
      <p>No posts found.</p>
    <?php endif; ?>
  </div>
</div>

<?php \Elementor\Plugin::instance()->frontend->end_excerpt_flag(); ?>
<?php get_footer(); ?>