<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\LicenseManager\Plugin;

add_filter( 'arts/license_manager/plugin/strings', 'arr_license_manager_plugin_strings' );
if ( ! function_exists( 'arr_license_manager_plugin_strings' ) ) {
	/**
	 * Configure strings for the Arts License Manager plugin.

	 * @param array $strings An array of strings to be modified.
	 *
	 * @return array Modified array of strings with ThemeForest URLs.
	 */
	function arr_license_manager_plugin_strings( $strings ) {
		$strings['item-page-url']     = esc_url( 'https://themeforest.net/item/arrigo-contemporary-and-creative-wordpress-theme/23262554?aid=artemsemkin&aso=buyer_admin_panel&aca=theme_license_page' );
		$strings['item-checkout-url'] = esc_url( 'https://themeforest.net/checkout/from_item/23262554?license=regular&support=bundle_6month&aid=artemsemkin&aso=buyer_admin_panel&aca=theme_license_page' );

		return $strings;
	}
}

Plugin::instance();
