<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'tgmpa_register', 'arr_register_required_plugins' );
if ( ! function_exists( 'arr_register_required_plugins' ) ) {
	/**
	 * Registers the required plugins for the theme.
	 *
	 * Defines an array of plugins to be installed and activated,
	 * along with their configuration settings. It uses the TGMPA library to
	 * handle the plugin installation and activation process.
	 *
	 * @return void
	 */
	function arr_register_required_plugins() {
		/*
		 * Array of plugin arrays. Required keys are name and slug.
		 * If the source is NOT from the .org repo, then source is also required.
		 */
		$plugins = array(
			array(
				'name'     => esc_html__( 'Advanced Custom Fields PRO', 'arrigo' ),
				'slug'     => 'advanced-custom-fields-pro',
				'source'   => esc_url( 'https://artemsemkin.com/wp-json/edd/v1/file/acf-pro/plugin' ),
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'Contact Form 7', 'arrigo' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'Elementor', 'arrigo' ),
				'slug'     => 'elementor',
				'required' => true,
			),
			array(
				'name'     => esc_html__( 'Kirki', 'arrigo' ),
				'slug'     => 'kirki',
				'required' => true,
			),
			array(
				'name'     => esc_html__( 'Intuitive Custom Post Order', 'arrigo' ),
				'slug'     => 'intuitive-custom-post-order',
				'required' => false,
			),
			array(
				'name'     => esc_html__( 'Arrigo Core', 'arrigo' ),
				'slug'     => 'arrigo-core',
				'source'   => esc_url( 'https://artemsemkin.com/wp-json/edd/v1/file/' . ARR_THEME_SLUG . '/core-plugin' ),
				'required' => true,
				'version'  => '3.1.0',
			),
		);

		/*
		* Array of configuration settings. Amend each line as needed.
		*
		*/
		$config = array(
			'id'           => ARR_THEME_SLUG,                 // Unique ID for hashing notices for multiple instances of TGMPA.
			'default_path' => '',                      // Default absolute path to bundled plugins.
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'has_notices'  => true,                    // Show admin notices or not.
			'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false,                   // Automatically activate plugins after installation or not.
			'message'      => '',                      // Message to output right before the plugins table.
		);

		tgmpa( $plugins, $config );
	}
}
