<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'after_setup_theme', 'arr_after_setup_theme' );
if ( ! function_exists( 'arr_after_setup_theme' ) ) {
	/**
	 * Initialize theme support features.
	 *
	 * @return void
	 */
	function arr_after_setup_theme() {
		global $content_width;

		if ( ! isset( $content_width ) ) {
			$content_width = 1170;
		}

		load_theme_textdomain( 'arrigo', ARR_THEME_PATH . '/languages' );

		add_editor_style( 'css/style-editor.css' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support(
			'html5',
			array(
				'comment-list',
				'comment-form',
				'search-form',
				'gallery',
				'caption',
			)
		);
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 80,
				'width'       => 80,
				'flex-height' => true,
				'flex-width'  => true,
				'header-text' => array( 'logo__text' ),
			)
		);
		add_theme_support( 'customize-selective-refresh-widgets' );
		add_theme_support(
			'post-formats',
			array(
				'aside',
				'gallery',
				'link',
				'image',
				'quote',
				'status',
				'video',
				'audio',
				'chat',
			)
		);
		add_theme_support( 'title-tag' );
	}
}
