<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once ARR_THEME_PATH . '/inc/classes/class-arr-add-custom-fonts.php';

/**
 * Initialize custom fonts
 */
add_action( 'after_setup_theme', 'arr_init_custom_fonts' );
if ( ! function_exists( 'arr_init_custom_fonts' ) ) {
	function arr_init_custom_fonts() {
		\Arr_Add_Custom_Fonts::instance();
	}
}

/**
 * Add custom fonts choice
 */
function arr_add_custom_choice() {
	return array(
		'fonts' => apply_filters( 'arr/kirki_font_choices', array() ),
	);
}

/**
 * Force Load all fonts variations (Kirki)
 */
add_action( 'after_setup_theme', 'arr_font_add_all_variants', 100 );
if ( ! function_exists( 'arr_font_add_all_variants' ) ) {
	function arr_font_add_all_variants() {
		$force_load_all_fonts_variations = get_theme_mod( 'force_load_all_fonts_variations', false );

		if ( class_exists( 'Kirki_Fonts_Google' ) && $force_load_all_fonts_variations ) {
			/** @disregard P1009 Assuming that the class exists in here */
			/** @disregard P1014 Assuming that the static property exists in here */
			Kirki_Fonts_Google::$force_load_all_variants = true;
		}
	}
}
