<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use \Arts\Utilities\Utilities;

if ( ! function_exists( 'arr_get_document_option' ) ) {
	/**
	 * Retrieve a specific document option for a given post.
	 *
	 * @param string   $option_name    The name of the option to retrieve.
	 * @param int|null $post_id        The ID of the post. Defaults to null.
	 * @param mixed    $option_default The value to return if the option is not found. Defaults to an empty string.
	 *
	 * @return mixed The value of the option, or the fallback value if not found.
	 *
	 * @deprecated 3.4.0 Use `\Arts\Utilities\Utilities::get_document_option()` method instead.
	 */
	function arr_get_document_option( $option, $post_id = null, $option_default = false ) {
		if ( did_action( 'elementor/loaded' ) ) {
			return Utilities::get_document_option( $option, $post_id, $option_default );
		} else {
			return $option_default;
		}
	}
}

if ( ! function_exists( 'arr_is_elementor_editor_active' ) ) {
	/**
	 * Checks if the Elementor editor is active and in preview mode.
	 *
	 * @return bool True if Elementor editor is active and in preview mode, false otherwise.
	 * @deprecated 3.4.0 Use `\Arts\Utilities\Utilities::is_elementor_editor_active()` method instead.
	 */
	function arr_is_elementor_editor_active() {
		return Utilities::is_elementor_editor_active();
	}
}

if ( ! function_exists( 'arr_is_elementor_feature_active' ) ) {
	/**
	 * Check if Elementor's experimental feature
	 * is supported and active
	 *
	 * @return bool
	 * @deprecated 3.4.0 Use `\Arts\Utilities\Utilities::is_elementor_feature_active()` method instead.
	 */
	function arr_is_elementor_feature_active( $feature_name ) {
		return Utilities::is_elementor_feature_active( $feature_name );
	}
}
