<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'elementor/theme/register_locations', 'arr_register_elementor_locations' );
if ( ! function_exists( 'arr_register_elementor_locations' ) ) {
	/**
	 * Register Elementor locations for header, footer, popup, single post, and single page.
	 *
	 * @param \Elementor\Theme_Manager $elementor_theme_manager Elementor theme manager instance.
	 */
	function arr_register_elementor_locations( $elementor_theme_manager ) {
		$elementor_theme_manager->register_location( 'header' );
		$elementor_theme_manager->register_location( 'footer' );
		$elementor_theme_manager->register_location( 'popup' );
		$elementor_theme_manager->register_location( 'single-post' );
		$elementor_theme_manager->register_location( 'single-page' );
	}
}
