<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_filter( 'register_post_type_args', 'arr_change_cpt_slug_portfolio', 10, 2 );
if ( ! function_exists( 'arr_change_cpt_slug_portfolio' ) ) {
	/**
	 * Change the slug for the Portfolio custom post type
	 *
	 * @param array  $args      Arguments for the post type.
	 * @param string $post_type Post type name.
	 *
	 * @return array Modified arguments.
	 */
	function arr_change_cpt_slug_portfolio( $args, $post_type ) {
		$enabled = get_theme_mod( 'enable_custom_portfolio_slug', false );
		$slug    = get_theme_mod( 'portfolio_slug' );

		if ( $enabled && ! empty( $slug ) && $post_type === 'arr_portfolio' ) {
			$args['rewrite']['slug'] = $slug;
		}

		return $args;
	}
}

add_filter( 'register_post_type_args', 'arr_change_cpt_slug_services', 10, 2 );
if ( ! function_exists( 'arr_change_cpt_slug_services' ) ) {
	/**
	 * Change the slug for the Services custom post type
	 *
	 * @param array  $args      Arguments for the post type.
	 * @param string $post_type Post type name.
	 *
	 * @return array Modified arguments.
	 */
	function arr_change_cpt_slug_services( $args, $post_type ) {
		$enabled = get_theme_mod( 'enable_custom_services_slug', false );
		$slug    = get_theme_mod( 'services_slug' );

		if ( $enabled && ! empty( $slug ) && $post_type === 'arr_services' ) {
			$args['rewrite']['slug'] = $slug;
		}

		return $args;
	}
}
