<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Kirki' ) ) {
	return;
}

add_filter( 'kirki_telemetry', '__return_false' );

add_action( 'after_setup_theme', 'arts_register_customizer_panels' );
if ( ! function_exists( 'arts_register_customizer_panels' ) ) {
	/**
	 * Register extra Customizer panels via Kirki
	 *
	 * @return void
	 */
	function arts_register_customizer_panels() {

		$priority = 1;

		/** @disregard P1009 Assuming that the class exists in here */
		Kirki::add_config(
			'arrigo',
			array(
				'capability'  => 'edit_theme_options',
				'option_type' => 'theme_mod',
			)
		);

		/**
		 * Section Preloader
		 */
		get_template_part( 'inc/customizer/preloader/preloader' );

		/**
		 * Panel General Style
		 */
		new \Kirki\Panel(
			'general-style',
			array(
				'priority' => $priority++,
				'title'    => esc_attr__( 'General Style', 'arrigo' ),
				'icon'     => 'dashicons-admin-appearance',
			)
		);
		get_template_part( '/inc/customizer/panels/general-style/general-style' );

		/**
		 * Panel Header
		 */
		new \Kirki\Panel(
			'header',
			array(
				'priority' => $priority++,
				'title'    => esc_attr__( 'Header', 'arrigo' ),
				'icon'     => 'dashicons-arrow-up-alt',
			)
		);
		get_template_part( '/inc/customizer/panels/header/header' );

		/**
		 * Panel Footer
		 */
		new \Kirki\Panel(
			'footer',
			array(
				'priority' => $priority++,
				'title'    => esc_attr__( 'Footer', 'arrigo' ),
				'icon'     => 'dashicons-arrow-down-alt',
			)
		);
		get_template_part( '/inc/customizer/panels/footer/footer' );

		/**
		 * Panel Blog
		 */
		new \Kirki\Panel(
			'blog',
			array(
				'priority' => $priority++,
				'title'    => esc_attr__( 'Blog', 'arrigo' ),
				'icon'     => 'dashicons-editor-bold',
			)
		);
		get_template_part( '/inc/customizer/panels/blog/blog' );

		/**
		 * Panel Options
		 */
		new \Kirki\Panel(
			'page',
			array(
				'priority' => $priority++,
				'title'    => esc_attr__( 'Options', 'arrigo' ),
				'icon'     => 'dashicons-admin-tools',
			)
		);
		get_template_part( '/inc/customizer/panels/page/page' );

		/**
		 * Extend Title & Tagline Section
		 */
		get_template_part( 'inc/customizer/title_tagline/title_tagline' );
	}
}
