<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

require_once __DIR__ . '/vendor/autoload.php';

/**
 * Theme Constants
 */
$theme_version = \Arts\Utilities\Utilities::get_parent_theme_version();
define( 'ARR_THEME_SLUG', 'arrigo' );
define( 'ARR_THEME_PATH', get_template_directory() );
define( 'ARR_THEME_URL', get_template_directory_uri() );
define( 'ARR_THEME_VERSION', $theme_version );

/**
* ACF Helper Functions
*/
require_once ARR_THEME_PATH . '/inc/functions/acf_helpers.php';

/**
* ACF Fields
*/
require_once ARR_THEME_PATH . '/inc/functions/acf.php';

/**
 * get_page_by_title() polyfill function
 */
require_once ARR_THEME_PATH . '/inc/functions/get_page_by_title.php';

/**
 * Add Custom Icons to Elementor
 */
require_once ARR_THEME_PATH . '/inc/functions/add_elementor_icons.php';

/**
 * Add a Pingback Url to Posts
 */
require_once ARR_THEME_PATH . '/inc/functions/add_pingback_url.php';

/**
 * Custom CPT slugs
 */
require_once ARR_THEME_PATH . '/inc/functions/change_cpt_slug.php';

/**
 * Comments Form
 */
require_once ARR_THEME_PATH . '/inc/functions/comments.php';

/**
 * Elementor Compatibility Functions
 */
require_once ARR_THEME_PATH . '/inc/functions/elementor_compatibility.php';

/**
 * Helper Functions (Elementor)
 */
require_once ARR_THEME_PATH . '/inc/functions/elementor_helpers.php';

/**
* Adobe Typekit & custom fonts support
*/
require_once ARR_THEME_PATH . '/inc/functions/fonts.php';

/**
 * Customizer Options (Kirki)
 */
require_once ARR_THEME_PATH . '/inc/customizer/customizer.php';

/**
 * Check If Footer Has Active Sidebars
 */
require_once ARR_THEME_PATH . '/inc/functions/footer_has_active_sidebars.php';

/**
 * Frontend Styles & Scripts
 */
require_once ARR_THEME_PATH . '/inc/functions/frontend.php';

/**
 * Get Post Author
 */
require_once ARR_THEME_PATH . '/inc/functions/get_post_author.php';

/**
 * hex2rgb
 */
require_once ARR_THEME_PATH . '/inc/functions/hex2rgb.php';

/**
 * Elementor check
 */
require_once ARR_THEME_PATH . '/inc/functions/is_built_with_elementor.php';

/**
 * Nav Menu
 */
require_once ARR_THEME_PATH . '/inc/functions/nav.php';

/**
 * Pagination for Posts
 */
require_once ARR_THEME_PATH . '/inc/functions/pagination.php';

/**
 * Password Form for Protected Posts
 */
require_once ARR_THEME_PATH . '/inc/functions/password_form.php';

/**
 * Markup for lazy images & backgrounds
 */
require_once ARR_THEME_PATH . '/inc/functions/the_lazy_image.php';

/**
 * Theme Support Features
 */
require_once ARR_THEME_PATH . '/inc/functions/theme_support.php';

/**
 * Widget Areas
 */
require_once ARR_THEME_PATH . '/inc/functions/widget_areas.php';

/**
 * Wrap Post Count in Widgets (categories, archives) into <span> Tag
 */
require_once ARR_THEME_PATH . '/inc/functions/wrap-count.php';

/**
 * WP Contact Form 7: Don't Wrap Form Fields Into </p>
 */
require_once ARR_THEME_PATH . '/inc/functions/wpcf7.php';

/**
 * Remove rendering of SVG duotone filters
 */
require_once ARR_THEME_PATH . '/inc/functions/remove_duotone_filters.php';

/**
 * Fix for Intuitive CPO plugin
 */
require_once ARR_THEME_PATH . '/inc/functions/hicpo_fix_capabilities.php';

/**
 * Load Required Plugins
 */
require_once ARR_THEME_PATH . '/inc/tgm/load_plugins.php';

/**
 * Demo Import
 */
require_once ARR_THEME_PATH . '/inc/importer/importer.php';

/**
 * Theme License & Updates Manager
 */
require_once ARR_THEME_PATH . '/inc/updater/updater.php';
