<?php
class Team_Hover_Banner_Widget extends \Elementor\Widget_Base {
  public function get_name() {
    return 'team_hover_banner_v4';
  }

  public function get_title() {
    return __('Team Hover Banner v4', 'plugin-name');
  }

  public function get_icon() {
    return 'eicon-posts-ticker';
  }

  public function get_categories() {
    return ['general'];
  }

  protected function register_controls() {
    $this->start_controls_section('content_section', [
      'label' => __('Content', 'plugin-name'),
      'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
    ]);

    $this->add_control('trigger_text', [
      'label' => __('Link Text', 'plugin-name'),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => 'Click to show banner',
    ]);

    $this->add_control('image', [
      'label' => __('Image', 'plugin-name'),
      'type' => \Elementor\Controls_Manager::MEDIA,
      'default' => ['url' => 'https://via.placeholder.com/150'],
    ]);

    $this->add_control('title', [
      'label' => __('Title', 'plugin-name'),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => 'John Doe',
    ]);

    $this->add_control('designation', [
      'label' => __('Designation', 'plugin-name'),
      'type' => \Elementor\Controls_Manager::TEXT,
      'default' => 'Designer',
    ]);

    $this->add_control('description', [
      'label' => __('Description', 'plugin-name'),
      'type' => \Elementor\Controls_Manager::TEXTAREA,
      'default' => 'This is a description of the person or card.',
    ]);

    $this->end_controls_section();
  }

  protected function render() {
    $settings = $this->get_settings_for_display();
    ?>
    <div class="thb-trigger" style="cursor: pointer;"><?php echo esc_html($settings['trigger_text']); ?></div>
    <div class="thb-banner">
      <div class="thb-close">Close</div>
      <div class="thb-left">
        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="">
      </div>
      <div class="thb-right">
        <div class="thb-title">
          <span><?php echo esc_html($settings['title']); ?></span>
          <em><?php echo esc_html($settings['designation']); ?></em>
        </div>
        <p><?php echo esc_html($settings['description']); ?></p>
      </div>
    </div>
    <?php
  }
}
