<?php
/**
 * Plugin Name: Team Hover Banner v4
 * Description: A reusable Elementor widget that shows a full-size banner on hover or click with customizable layout and styling.
 * Version: 2.0
 * Author: Hassan Shahnaz
 * Author URI: https://hassanshahbaz.com
 */

if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

function register_team_hover_banner_widget( $widgets_manager ) {
  require_once( __DIR__ . '/widget-team-hover-banner.php' );
  $widgets_manager->register( new \Team_Hover_Banner_Widget() );
}
add_action( 'elementor/widgets/register', 'register_team_hover_banner_widget' );

add_action('wp_footer', function() {
  ?>
  <script>
    document.addEventListener("DOMContentLoaded", function () {
      document.querySelectorAll(".thb-trigger").forEach(function (trigger) {
        trigger.addEventListener("click", function (e) {
          e.preventDefault();
          const container = this.closest(".elementor-widget-container");
          const banner = container.querySelector(".thb-banner");
          banner?.classList.add("visible");
        });
      });

      document.querySelectorAll(".thb-close").forEach(function (closeBtn) {
        closeBtn.addEventListener("click", function (e) {
          e.preventDefault();
          const banner = this.closest(".thb-banner");
          banner.classList.remove("visible");
        });
      });
    });
  </script>
  <style>
    .thb-banner {
      display: none;
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: auto;
      z-index: 100;
      background: #fff;
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
      transition: all 0.3s ease;
    }
    .thb-banner.visible {
      display: flex;
    }
    .thb-banner .thb-left {
      width: 20%;
      padding: 15px;
    }
    .thb-banner .thb-left img {
      max-width: 100%;
      height: auto;
      display: block;
    }
    .thb-banner .thb-right {
      width: 80%;
      padding: 15px;
    }
    .thb-banner .thb-title {
      display: flex;
      justify-content: space-between;
      font-size: 1.1em;
      margin-bottom: 8px;
    }
    .thb-close {
      position: absolute;
      top: 10px;
      right: 15px;
      background: #000;
      color: #fff;
      padding: 2px 8px;
      cursor: pointer;
      border-radius: 4px;
      font-size: 12px;
    }
    @media (max-width: 768px) {
      .thb-banner {
        flex-direction: column;
      }
      .thb-banner .thb-left,
      .thb-banner .thb-right {
        width: 100%;
      }
    }
  </style>
  <?php
});
