<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Plugin;

if (!defined('ABSPATH')) exit;

class Custom_Content_Carousel extends Widget_Base {

    public function get_name() {
        return 'custom_content_carousel';
    }

    public function get_title() {
        return __('Custom Content Carousel', 'elementor');
    }

    public function get_icon() {
        return 'eicon-slider-push';
    }

    public function get_categories() {
        return ['general'];
    }

    public function get_style_depends() {
        return ['swiper-style', 'flex-carousel-style'];
    }

    public function get_script_depends() {
        return ['swiper-script', 'flex-carousel-script'];
    }

    protected function register_controls() {
        $this->start_controls_section('carousel_options', [
            'label' => __('Carousel Options', 'elementor'),
        ]);

        $this->add_control('show_arrows', [
            'label' => __('Show Arrows', 'elementor'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ]);

        $this->add_control('show_dots', [
            'label' => __('Show Dots', 'elementor'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ]);

        $this->end_controls_section();

        $this->start_controls_section('slides_section', [
            'label' => __('Slides', 'elementor'),
        ]);

        $repeater = new Repeater();

        $repeater->add_control('template_id', [
            'label' => __('Elementor Template', 'elementor'),
            'type' => Controls_Manager::SELECT2,
            'options' => $this->get_elementor_templates(),
            'label_block' => true,
        ]);

        $this->add_control('slides', [
            'label' => __('Carousel Slides', 'elementor'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'title_field' => 'Template ID: {{{ template_id }}}',
        ]);

        $this->end_controls_section();
    }

    private function get_elementor_templates() {
        $options = [];
        $posts = get_posts([
            'post_type' => 'elementor_library',
            'posts_per_page' => -1
        ]);
        foreach ($posts as $post) {
            $options[$post->ID] = $post->post_title;
        }
        return $options;
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        if (empty($settings['slides'])) return;

        echo '<div class="swiper flex-carousel-container"><div class="swiper-wrapper">';
        foreach ($settings['slides'] as $slide) {
            echo '<div class="swiper-slide flex-carousel-slide">';
            if (!empty($slide['template_id'])) {
                echo Plugin::instance()->frontend->get_builder_content_for_display($slide['template_id']);
            }
            echo '</div>';
        }
        echo '</div>';
        if ($settings['show_dots'] === 'yes') echo '<div class="swiper-pagination"></div>';
        if ($settings['show_arrows'] === 'yes') {
            echo '<div class="swiper-button-prev"></div>';
            echo '<div class="swiper-button-next"></div>';
        }
        echo '</div>';
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Custom_Content_Carousel());
