<?php
/*
Plugin Name: Custom Content Carousel
Description: A responsive Elementor carousel widget with template support and full style controls.
Version: 1.3
Author: Hassan Shahbaz
Author URI: https://arpinax.com
*/

if (!defined('ABSPATH')) exit;

add_action('plugins_loaded', function () {
    if (did_action('elementor/loaded')) {
        add_action('elementor/widgets/register', function($widgets_manager) {
            require_once plugin_dir_path(__FILE__) . 'widgets/flex-carousel-widget.php';
        });
    }
});

add_action('elementor/frontend/after_enqueue_scripts', function() {
    wp_enqueue_style('swiper-style', 'https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css');
    wp_enqueue_script('swiper-script', 'https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js', [], null, true);
    wp_enqueue_style('flex-carousel-style', plugin_dir_url(__FILE__) . 'assets/flex-carousel.css');
    wp_enqueue_script('flex-carousel-script', plugin_dir_url(__FILE__) . 'assets/flex-carousel.js', ['swiper-script'], null, true);
});
