document.addEventListener('DOMContentLoaded', function () {
  const carousels = document.querySelectorAll('.flex-carousel-container');
  carousels.forEach(function (carouselEl) {
    const swiper = new Swiper(carouselEl, {
      loop: true,
      slidesPerView: 1,
      spaceBetween: 30,
      speed: 800,
      effect: 'fade',
      fadeEffect: { crossFade: true },
      autoplay: {
        delay: 5000,
        disableOnInteraction: false,
      },
      navigation: {
        nextEl: carouselEl.querySelector('.swiper-button-next'),
        prevEl: carouselEl.querySelector('.swiper-button-prev'),
      },
      pagination: {
        el: carouselEl.querySelector('.swiper-pagination'),
        clickable: true,
      },
    });

    // Pause on mouse hover
    carouselEl.addEventListener('mouseenter', () => swiper.autoplay.stop());
    carouselEl.addEventListener('mouseleave', () => swiper.autoplay.start());
  });
});
