<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Widget Social
 */
class Arrigo_Widget_Social extends WP_Widget {
	function __construct() {
		parent::__construct(
			'arrigo_social',
			__( 'Arrigo: Social Media', 'arrigo' ),
			array( 'description' => __( 'Displays social media links', 'arrigo' ) )
		);

		$this->socials = apply_filters(
			'arts/widgets/arrigo_widget_social/icons',
			array(
				'facebook'    => array(
					'title'      => esc_html__( 'Facebook URL', 'arrigo' ),
					'icon'       => 'fa fa-facebook-f fa-fw',
					'aria-label' => esc_html__( 'Facebook', 'arrigo' ),
				),
				'twitter'     => array(
					'title'      => esc_html__( 'Twitter URL', 'arrigo' ),
					'icon'       => 'fa fa-twitter fa-fw',
					'aria-label' => esc_html__( 'Twitter', 'arrigo' ),
				),
				'instagram'   => array(
					'title'      => esc_html__( 'Instagram URL', 'arrigo' ),
					'icon'       => 'fa fa-instagram fa-fw',
					'aria-label' => esc_html__( 'Instagram', 'arrigo' ),
				),
				'linkedin'    => array(
					'title'      => esc_html__( 'LinkedIn URL', 'arrigo' ),
					'icon'       => 'fa fa-linkedin fa-fw',
					'aria-label' => esc_html__( 'LinkedIn', 'arrigo' ),
				),
				'google_plus' => array(
					'title'      => esc_html__( 'Google Plus URL', 'arrigo' ),
					'icon'       => 'fa fa-google-plus fa-fw',
					'aria-label' => esc_html__( 'Google Plus', 'arrigo' ),
				),
				'vk'          => array(
					'title'      => esc_html__( 'VK URL', 'arrigo' ),
					'icon'       => 'fa fa-vk fa-fw',
					'aria-label' => esc_html__( 'VK', 'arrigo' ),
				),
				'youtube'     => array(
					'title'      => esc_html__( 'YouTube URL', 'arrigo' ),
					'icon'       => 'fa fa-youtube fa-fw',
					'aria-label' => esc_html__( 'YouTube', 'arrigo' ),
				),
				'vimeo'       => array(
					'title'      => esc_html__( 'Vimeo URL', 'arrigo' ),
					'icon'       => 'fa fa-vimeo fa-fw',
					'aria-label' => esc_html__( 'Vimeo', 'arrigo' ),
				),
				'dribbble'    => array(
					'title'      => esc_html__( 'Dribbble URL', 'arrigo' ),
					'icon'       => 'fa fa-dribbble fa-fw',
					'aria-label' => esc_html__( 'Dribbble', 'arrigo' ),
				),
				'pinterest'   => array(
					'title'      => esc_html__( 'Pinterest URL', 'arrigo' ),
					'icon'       => 'fa fa-pinterest fa-fw',
					'aria-label' => esc_html__( 'Pinterest', 'arrigo' ),
				),
				'behance'     => array(
					'title'      => esc_html__( 'Behance URL', 'arrigo' ),
					'icon'       => 'fa fa-behance fa-fw',
					'aria-label' => esc_html__( 'Behance', 'arrigo' ),
				),
				'flickr'      => array(
					'title'      => esc_html__( 'Flickr URL', 'arrigo' ),
					'icon'       => 'fa fa-flickr fa-fw',
					'aria-label' => esc_html__( 'Flickr', 'arrigo' ),
				),
				'tumblr'      => array(
					'title'      => esc_html__( 'Tumblr URL', 'arrigo' ),
					'icon'       => 'fa fa-tumblr fa-fw',
					'aria-label' => esc_html__( 'Tumblr', 'arrigo' ),
				),
				'vine'        => array(
					'title'      => esc_html__( 'Vine URL', 'arrigo' ),
					'icon'       => 'fa fa-vine fa-fw',
					'aria-label' => esc_html__( 'Vine', 'arrigo' ),
				),
				'github'      => array(
					'title'      => esc_html__( 'Github URL', 'arrigo' ),
					'icon'       => 'fa fa-github fa-fw',
					'aria-label' => esc_html__( 'Github', 'arrigo' ),
				),
				'soundcloud'  => array(
					'title'      => esc_html__( 'SoundCloud URL', 'arrigo' ),
					'icon'       => 'fa fa-soundcloud fa-fw',
					'aria-label' => esc_html__( 'SoundCloud', 'arrigo' ),
				),
				'telegram'    => array(
					'title'      => esc_html__( 'Telegram URL', 'arrigo' ),
					'icon'       => 'fa fa-telegram fa-fw',
					'aria-label' => esc_html__( 'Telegram', 'arrigo' ),
				),
				'medium'      => array(
					'title'      => esc_html__( 'Medium URL', 'arrigo' ),
					'icon'       => 'fa fa-medium fa-fw',
					'aria-label' => esc_html__( 'Medium', 'arrigo' ),
				),
				'skype'       => array(
					'title'      => esc_html__( 'Skype URL', 'arrigo' ),
					'icon'       => 'fa fa-skype fa-fw',
					'aria-label' => esc_html__( 'Skype', 'arrigo' ),
				),
				'whatsapp'    => array(
					'title'      => esc_html__( 'WhatsApp URL', 'arrigo' ),
					'icon'       => 'fa fa-whatsapp fa-fw',
					'aria-label' => esc_html__( 'WhatsApp', 'arrigo' ),
				),
				'slack'       => array(
					'title'      => esc_html__( 'Slack URL', 'arrigo' ),
					'icon'       => 'fa fa-slack fa-fw',
					'aria-label' => esc_html__( 'Slack', 'arrigo' ),
				),
				'tiktok'      => array(
					'title'      => esc_html__( 'TikTok URL', 'arrigo' ),
					'icon'       => 'fa fa-tiktok fa-fw',
					'aria-label' => esc_html__( 'TikTok', 'arrigo' ),
				),
			)
		);
	}

	/**
	 * Social Medias
	 *
	 * @var array
	 */
	private $socials;

	/**
	 * Display widget on frontend
	 *
	 * @param array $args     widget arguments.
	 * @param array $instance saved data from settings
	 */
	function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$widget_id = $args['widget_id'];

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}

		?>
			<ul class="social">
				<?php foreach ( $this->socials as $index => $item ) : ?>
					<?php $option = array_key_exists( $index, $instance ) ? $instance[ $index ] : ''; ?>
					<?php $aria_label = array_key_exists( 'aria-label', $item ) ? $item['aria-label'] : ''; ?>
					<?php $icon = array_key_exists( 'icon', $item ) ? $item['icon'] : ''; ?>
					<?php if ( ! empty( $option ) ) : ?>
						<li class="social__item">
							<a class="social__icon <?php echo esc_attr( $icon ); ?>" href="<?php echo esc_url( $option ); ?>" target="_blank"<?php if ( $aria_label ) : ?> aria-label="<?php echo esc_attr( $aria_label ); ?>"<?php endif; ?>>
								<svg viewBox="0 0 152 152" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
									<g fill="none" fill-rule="evenodd">
										<g transform="translate(-134.000000, -98.000000)">
											<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
										</g>
									</g>
								</svg>
							</a>
						</li>
					<?php endif; ?>
				<?php endforeach; ?>
			</ul>
		<?php
		echo $args['after_widget'];
	}

	/**
	 * Admin settings
	 *
	 * @param array $instance saved data from settings
	 */
	function form( $instance ) {
		$title = @ $instance['title'] ? : '';

		?>

		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'arrigo' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>
		<br>
		<?php foreach ( $this->socials as $index => $item ) : ?>
			<?php
					$field_name  = $this->get_field_name( $index );
					$field_value = @ $instance[ $index ] ? : '';
					$field_id    = $this->get_field_id( $index );
					$field_title = $item['title'];
			?>
				<p>
					<label for="<?php echo esc_html( $field_id ); ?>"><?php echo esc_html( $item['title'] ); ?></label> 
					<input class="widefat" id="<?php echo esc_html( $field_id ); ?>" name="<?php echo esc_html( $field_name ); ?>" type="text" value="<?php echo esc_url( $field_value ); ?>">
				</p>
		<?php endforeach; ?>

		<?php
	}

	/**
	 * Sanitize and save widget settings.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance new settings
	 * @param array $old_instance previous settings
	 *
	 * @return array data to save
	 */
	function update( $new_instance, $old_instance ) {

		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';

		foreach ( $this->socials as $index => $item ) {

			$url                = $new_instance[ $index ];
			$instance[ $index ] = '';

			if ( ! empty( $url ) ) {
				$instance[ $index ] = esc_url( $url );
			}
		}

		return $instance;
	}
}
