<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Widget Copyright
 */
class Arrigo_Widget_Copyright extends WP_Widget {
	function __construct() {
		parent::__construct(
			'arrigo_copyright',
			__( 'Arrigo: Copyright', 'arrigo' ),
			array( 'description' => __( 'Displays small text.', 'arrigo' ) )
		);
	}

	/**
	 * Display widget on frontend
	 *
	 * @param array $args     widget arguments.
	 * @param array $instance saved data from settings
	 */
	function widget( $args, $instance ) {

		$text = ( ! empty( $instance['text'] ) ) ? $instance['text'] : '';

		echo $args['before_widget'];
		?>

		<?php if ( ! empty( $text ) ) : ?>
			<small><?php echo esc_html( $text ); ?></small>
		<?php endif; ?>

		<?php
		echo $args['after_widget'];
	}

	/**
	 * Admin settings
	 *
	 * @param array $instance saved data from settings
	 */
	function form( $instance ) {

		$text = @ $instance['text'] ? : '';

		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'text' ); ?>"><?php _e( 'Text', 'arrigo' ); ?></label> 
			<textarea class="widefat" id="<?php echo $this->get_field_id( 'text' ); ?>" name="<?php echo $this->get_field_name( 'text' ); ?>"><?php echo esc_attr( $text ); ?></textarea>
		</p>
		<?php
	}

	/**
	 * Sanitize and save widget settings.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance new settings
	 * @param array $old_instance previous settings
	 *
	 * @return array data to save
	 */
	function update( $new_instance, $old_instance ) {

		$instance         = array();
		$instance['text'] = ( ! empty( $new_instance['text'] ) ) ? esc_html( $new_instance['text'] ) : '';

		return $instance;
	}
}
