<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'init', 'arr_register_taxonomies' );
function arr_register_taxonomies() {
	/**
	 * Portfolio Category
	 */
	register_taxonomy(
		'arr_portfolio_category',
		array( 'arr_portfolio' ),
		array(
			'labels'            => array(
				'name'                       => _x( 'Portfolio Categories', 'taxonomy general name', 'arrigo' ),
				'singular_name'              => _x( 'Portfolio Category', 'taxonomy singular name', 'arrigo' ),
				'search_items'               => __( 'Search Portfolio Categories', 'arrigo' ),
				'all_items'                  => __( 'All Portfolio Categories', 'arrigo' ),
				'parent_item'                => __( 'Parent Portfolio Category', 'arrigo' ),
				'parent_item_colon'          => __( 'Parent Portfolio Category:', 'arrigo' ),
				'edit_item'                  => __( 'Edit Portfolio Category', 'arrigo' ),
				'update_item'                => __( 'Update Portfolio Category', 'arrigo' ),
				'add_new_item'               => __( 'Add New Portfolio Category', 'arrigo' ),
				'new_item_name'              => __( 'New Portfolio Category', 'arrigo' ),
				'separate_items_with_commas' => __( 'Separate portfolio categories with commas', 'arrigo' ),
				'add_or_remove_items'        => __( 'Add or remove writers', 'arrigo' ),
				'choose_from_most_used'      => __( 'Choose from the most used portfolio categories', 'arrigo' ),
				'not_found'                  => __( 'No portfolio categories found.', 'arrigo' ),
				'menu_name'                  => __( 'Portfolio Categories', 'arrigo' ),
			),
			'public'            => true,
			'hierarchical'      => false,
			'show_admin_column' => true,
			'query_var'         => true,
		)
	);
}
