<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'init', 'arr_register_post_types' );
function arr_register_post_types() {
	$priority = 4;

	/**
	 * Portfolio
	 */
	register_post_type(
		'arr_portfolio',
		array(
			'labels'        => array(
				'name'                  => __( 'Portfolio', 'arrigo' ),
				'singular_name'         => __( 'Portfolio Item', 'arrigo' ),
				'add_new'               => __( 'Add New', 'arrigo' ),
				'add_new_item'          => __( 'Add New Portfolio Item', 'arrigo' ),
				'edit_item'             => __( 'Edit Portfolio Item', 'arrigo' ),
				'new_item'              => __( 'New Portfolio Item', 'arrigo' ),
				'view_item'             => __( 'View Portfolio Item', 'arrigo' ),
				'search_items'          => __( 'Find Portfolio Item', 'arrigo' ),
				'not_found'             => __( 'No portfolio items found.', 'arrigo' ),
				'not_found_in_trash'    => __( 'No portfolio items found in trash.', 'arrigo' ),
				'menu_name'             => __( 'Arrigo Portfolio', 'arrigo' ),
				'featured_image'        => __( 'Cover Image', 'arrigo' ),
				'set_featured_image'    => __( 'Set Cover Image', 'arrigo' ),
				'remove_featured_image' => __( 'Remove Cover Image', 'arrigo' ),
				'use_featured_image'    => __( 'Use Cover Image', 'arrigo' ),
			),
			'rewrite'       => array(
				'slug' => 'portfolio',
			),
			'public'        => true,
			'show_in_menu'  => true,
			'menu_icon'     => 'dashicons-text',
			'menu_position' => $priority++,
			'supports'      => array( 'title', 'page-attributes', 'thumbnail' ),
			'taxonomies'    => array( 'arr_portfolio_category' ),
			'has_archive'   => false,
		)
	);

	/**
	 * Services
	 */
	register_post_type(
		'arr_services',
		array(
			'labels'        => array(
				'name'               => __( 'Services', 'arrigo' ),
				'singular_name'      => __( 'Service', 'arrigo' ),
				'add_new'            => __( 'Add New', 'arrigo' ),
				'add_new_item'       => __( 'Add New Service', 'arrigo' ),
				'edit_item'          => __( 'Edit Service', 'arrigo' ),
				'new_item'           => __( 'New Service', 'arrigo' ),
				'view_item'          => __( 'View Service', 'arrigo' ),
				'search_items'       => __( 'Find Service', 'arrigo' ),
				'not_found'          => __( 'No services found.', 'arrigo' ),
				'not_found_in_trash' => __( 'No services found in trash.', 'arrigo' ),
				'menu_name'          => __( 'Arrigo Services', 'arrigo' ),
			),
			'rewrite'       => array(
				'slug' => 'services',
			),
			'public'        => true,
			'show_in_menu'  => true,
			'menu_icon'     => 'dashicons-text',
			'menu_position' => $priority++,
			'supports'      => array( 'title', 'page-attributes', 'thumbnail', 'service_short_description' ),
			'has_archive'   => false,
		)
	);
}

