<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Testimonials_Slider_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-testimonials-slider';
	}

	public function get_title() {
		return _x( 'Testimonials Slider', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	public function get_style_depends() {
		return array( 'swiper' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions'        => array( 'widgetType' => $name ),
			'fields'            => array(),
			'integration-class' => 'WPML_Arrigo_Elementor_Testimonials_Slider_Widget',
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Testimonials', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new \Elementor\Repeater();

		/**
		 * Avatar
		 */
		$repeater->add_control(
			'avatar_heading',
			array(
				'label' => _x( 'Avatar', 'Elementor Widget', 'arrigo' ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			)
		);

		/**
		 * Avatar Src
		 */
		$repeater->add_control(
			'testimonial_avatar',
			array(
				'label'   => _x( 'Choose Image', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => array(
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				),
			)
		);

		/**
		 * Testimonial Text
		 */
		$repeater->add_control(
			'testimonial_text',
			array(
				'label'       => _x( 'Text', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => _x( 'Edit text...', 'Elementor Widget', 'arrigo' ),
			)
		);

		/**
		 * Testimonial Author Name
		 */
		$repeater->add_control(
			'testimonial_author_name',
			array(
				'label'       => _x( 'Name', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => _x( 'Edit name...', 'Elementor Widget', 'arrigo' ),
			)
		);

		/**
		 * Testimonial Author Position
		 */
		$repeater->add_control(
			'testimonial_author_position',
			array(
				'label'       => _x( 'Position', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => _x( 'Edit position...', 'Elementor Widget', 'arrigo' ),
			)
		);

		/**
		 * Testimonials Repeater Control
		 */
		$this->add_control(
			'testimonials',
			array(
				'type'          => \Elementor\Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ testimonial_author_name || testimonial_text }}}',
				'prevent_empty' => true,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Slider
		 */
		$this->start_controls_section(
			'slider_section',
			array(
				'label' => _x( 'Slider', 'Elementor Widget', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_SETTINGS,
			)
		);

		/**
		 * Navigation
		 */
		$this->add_control(
			'enable_navigation',
			array(
				'label'   => _x( 'Enable Navigation Arrows', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Dots
		 */
		$this->add_control(
			'enable_dots',
			array(
				'label'   => _x( 'Enable Dots', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Counter
		 */
		$this->add_control(
			'enable_counter',
			array(
				'label'   => _x( 'Enable Counter', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Autoplay
		 */
		$this->add_control(
			'enable_autoplay',
			array(
				'label'   => _x( 'Autoplay', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
			)
		);

		/**
		 * Autoplay Delay
		 */
		$this->add_control(
			'autoplay_delay',
			array(
				'label'     => _x( 'Autoplay Delay (ms)', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => array(
					'ms' => array(
						'min'  => 1000,
						'max'  => 60000,
						'step' => 100,
					),
				),
				'default'   => array(
					'unit' => 'ms',
					'size' => 6000,
				),
				'condition' => array(
					'enable_autoplay' => 'yes',
				),
			)
		);

		/**
		 * Speed
		 */
		$this->add_control(
			'speed',
			array(
				'label'   => _x( 'Speed', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::SLIDER,
				'range'   => array(
					'ms' => array(
						'min'  => 100,
						'max'  => 10000,
						'step' => 100,
					),
				),
				'default' => array(
					'unit' => 'ms',
					'size' => 800,
				),
			)
		);

		/**
		 * Direction
		 */
		$this->add_control(
			'direction',
			array(
				'label'   => _x( 'Direction', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'ltr',
				'options' => array(
					'ltr' => array(
						'title' => _x( 'Left to Right', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-chevron-double-right',
					),
					'rtl' => array(
						'title' => _x( 'Right to Left', 'Elementor Widget', 'arrigo' ),
						'icon'  => 'eicon-chevron-double-left',
					),
				),
				'toggle'  => false,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Animation
		 */
		$this->start_controls_section(
			'animation_section',
			array(
				'label' => _x( 'Animation', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			)
		);

		/**
		 * OS Animation
		 */
		$this->add_control(
			'enable_animation',
			array(
				'label'        => _x( 'Enable on-scroll animation', 'Elementor Widget', 'arrigo' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'return_value' => 'data-os-animation="data-os-animation"',
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'controls', 'class', 'slider__controls' );
		$this->add_render_attribute(
			'swiper',
			array(
				'class'      => array( 'swiper', 'swiper-container', 'swiper-container-initialized', 'js-slider-testimonials' ),
				'data-speed' => is_array( $settings['speed'] ) ? $settings['speed']['size'] : 0,
				'dir'        => $settings['direction'],
			)
		);

		if ( $settings['enable_dots'] && ! $settings['enable_navigation'] ) {
			$this->add_render_attribute( 'controls', 'class', 'justify-content-center' );
		}

		if ( $settings['enable_autoplay'] ) {
			$this->add_render_attribute(
				'swiper',
				array(
					'data-autoplay-enabled' => 'true',
					'data-autoplay-delay'   => is_array( $settings['autoplay_delay'] ) ? $settings['autoplay_delay']['size'] : 0,
				)
			);
		}
		?>
		<div class="container slider slider-testimonials" <?php echo $settings['enable_animation']; ?>>
			<div class="row justify-content-between">
				<div class="col-lg-10 order-lg-2">
					<div <?php $this->print_render_attribute_string( 'swiper' ); ?>>
						<div class="swiper-wrapper">
							<?php foreach ( $settings['testimonials'] as $index => $item ) : ?>
								<div class="swiper-slide">
									<?php if ( ! empty( $item['testimonial_avatar'] ) ) : ?>
										<?php
											arr_the_lazy_image(
												array(
													'id'   => $item['testimonial_avatar']['id'],
													'type' => 'image',
													'class' => array(
														'wrapper' => false,
														'image' => array( 'swiper-lazy', 'of-cover', 'slider-testimonials__author-avatar' ),
													),
												)
											);
										?>
									<?php endif; ?>
									<?php if ( ! empty( $item['testimonial_text'] ) ) : ?>
										<?php
											$keyText = $this->get_repeater_setting_key( 'testimonial_text', 'testimonials', $index );
											$this->add_inline_editing_attributes( $keyText );
										?>
										<p class="slider-testimonials__text">
											<span <?php $this->print_render_attribute_string( $keyText ); ?>><?php echo $item['testimonial_text']; ?></span>
										</p>
									<?php endif; ?>
									<?php if ( ! empty( $item['testimonial_author_name'] ) || ! empty( $item['testimonial_author_position'] ) ) : ?>
										<div class="slider-testimonials__author">
											<div class="slider-testimonials__author-line"></div>
											<?php if ( ! empty( $item['testimonial_author_name'] ) ) : ?>
												<?php
													$keyName = $this->get_repeater_setting_key( 'testimonial_author_name', 'testimonials', $index );
													$this->add_inline_editing_attributes( $keyName );
												?>
												<div class="slider-testimonials__author-name">
													<span <?php $this->print_render_attribute_string( $keyName ); ?>><?php echo $item['testimonial_author_name']; ?></span>
												</div>
											<?php endif; ?>
											<?php if ( ! empty( $item['testimonial_author_position'] ) ) : ?>
												<?php
													$keyPosition = $this->get_repeater_setting_key( 'testimonial_author_position', 'testimonials', $index );
													$this->add_inline_editing_attributes( $keyPosition );
												?>
												<div class="slider-testimonials__author-subline">
													<span <?php $this->print_render_attribute_string( $keyPosition ); ?>><?php echo $item['testimonial_author_position']; ?></span>
												</div>
											<?php endif; ?>
										</div>
									<?php endif; ?>
								</div>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
				<div class="col-lg-1 order-lg-1">
					<?php if ( $settings['enable_navigation'] || $settings['enable_dots'] ) : ?>
						<div <?php $this->print_render_attribute_string( 'controls' ); ?>>
							<?php if ( $settings['enable_navigation'] ) : ?>
								<div class="slider__arrow slider-testimonials__arrow js-slider-testimonials__arrow-prev eicon-angle-left"></div>
							<?php endif; ?>
							<?php if ( $settings['enable_dots'] ) : ?>
								<div class="slider__dots js-slider-testimonials__dots">
									<div class="slider__dot slider__dot_active"></div>
									<div class="slider__dot"></div>
									<div class="slider__dot"></div>
									<div class="slider__dot"></div>
								</div>
							<?php endif; ?>
							<?php if ( $settings['enable_navigation'] ) : ?>
								<div class="slider__arrow slider-testimonials__arrow js-slider-testimonials__arrow-next eicon-angle-right"></div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
				</div>
				<div class="col-lg-1 align-self-end order-lg-3 d-none d-lg-block">
					<?php if ( $settings['enable_counter'] ) : ?>
						<div class="slider__counter-big">
							<div class="swiper swiper-container swiper-container-initialized slider__counter-big-current slider-testimonials__counter-big-current js-slider-testimonials-counter-current">
								<div class="swiper-wrapper"></div>
							</div>
							<div class="slider__counter-big-total js-slider-testimonials-counter-total"></div>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<?php
	}

	protected function content_template() {
		?>
		<#
		view.addRenderAttribute('controls', 'class', 'slider__controls');
		view.addRenderAttribute(
			'swiper', {
				'class': ['swiper', 'swiper-container', 'swiper-container-initialized', 'js-slider-testimonials'],
				'data-speed': settings.speed.size,
				'dir': settings.direction,
			}
		);

		if ( settings.enable_dots && !settings.enable_navigation) {
			view.addRenderAttribute('controls', 'class', 'justify-content-center');
		}

		if ( settings.enable_autoplay ) {
			view.addRenderAttribute(
				'swiper', {
					'data-autoplay-enabled': 'true',
					'data-autoplay-delay': settings.autoplay_delay.size,
				}
			);
		}
		#>
		<div class="container slider slider-testimonials">
			<div class="row justify-content-between">
				<div class="col-lg-10 order-lg-2">
					<div {{{ view.getRenderAttributeString( 'swiper' ) }}}>
						<div class="swiper-wrapper">
							<# _.each( settings.testimonials, function(item, index) { #>
								<div class="swiper-slide">
									<# if (item.testimonial_avatar) { #>
										<img class="slider-testimonials__author-avatar" src="{{{ item.testimonial_avatar.url }}}" alt=""/>
									<# } #>
									<# if (item.testimonial_text) { #>
										<#
											var keyText = view.getRepeaterSettingKey( 'testimonial_text', 'testimonials', index );
											view.addInlineEditingAttributes( keyText );
										#>
										<p class="slider-testimonials__text">
											<span {{{ view.getRenderAttributeString( keyText ) }}}>{{{ item.testimonial_text }}}</span>
										</p>
									<# } #>
									<# if (item.testimonial_author_name || item.testimonial_author_position) { #>
										<div class="slider-testimonials__author">
											<div class="slider-testimonials__author-line"></div>
											<# if (item.testimonial_author_name) { #>
												<#
													var keyName = view.getRepeaterSettingKey( 'testimonial_author_name', 'testimonials', index );
													view.addInlineEditingAttributes( keyName );
												#>
												<div class="slider-testimonials__author-name">
													<span {{{ view.getRenderAttributeString( keyName ) }}}>{{{ item.testimonial_author_name }}}</span>
												</div>
											<# } #>
											<# if (item.testimonial_author_position) { #>
												<#
													var keyPosition = view.getRepeaterSettingKey( 'testimonial_author_position', 'testimonials', index );
													view.addInlineEditingAttributes( keyPosition );
												#>
												<div class="slider-testimonials__author-subline">
													<span {{{ view.getRenderAttributeString( keyPosition ) }}}>{{{ item.testimonial_author_position }}}</span>
												</div>
											<# } #>
										</div>
									<# } #>
								</div>
							<# }); #>
						</div>
					</div>
				</div>
				<div class="col-lg-1 order-lg-1">
					<# if (settings.enable_navigation || settings.enable_dots ) { #>
						<div {{{ view.getRenderAttributeString( 'controls' ) }}}>
							<# if (settings.enable_navigation ) { #>
								<div class="slider__arrow slider-testimonials__arrow js-slider-testimonials__arrow-prev eicon-angle-left"></div>
							<# } #>
							<# if (settings.enable_dots ) { #>
								<div class="slider__dots js-slider-testimonials__dots">
									<div class="slider__dot slider__dot_active"></div>
									<div class="slider__dot"></div>
									<div class="slider__dot"></div>
									<div class="slider__dot"></div>
								</div>
							<# } #>
							<# if (settings.enable_navigation ) { #>
								<div class="slider__arrow slider-testimonials__arrow js-slider-testimonials__arrow-next eicon-angle-right"></div>
							<# } #>
						</div>
					<# } #>
				</div>
				<div class="col-lg-1 align-self-end order-lg-3 d-none d-lg-block">
					<# if (settings.enable_counter ) { #>
						<div class="slider__counter-big">
							<div class="swiper swiper-container swiper-container-initialized slider__counter-big-current slider-testimonials__counter-big-current js-slider-testimonials-counter-current">
								<div class="swiper-wrapper"></div>
							</div>
							<div class="slider__counter-big-total js-slider-testimonials-counter-total"></div>
						</div>
					<# } #>
				</div>
			</div>
		</div>
		<?php
	}
}
