<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Team_Member_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-team-member';
	}

	public function get_title() {
		return _x( 'Team Member', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions' => array( 'widgetType' => $name ),
			'fields'     => array(
				array(
					'field'       => 'name',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Name', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
				array(
					'field'       => 'position',
					'type'        => sprintf( '<strong>%1$s</strong><br>%2$s', $title, _x( 'Position', 'Elementor Widget', 'arrigo' ) ),
					'editor_type' => 'LINE',
				),
			),
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Name
		 */
		$this->add_control(
			'name',
			array(
				'label'       => _x( 'Name', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => _x( 'Edit name...', 'Elementor Widget', 'arrigo' ),
			)
		);

		/**
		 * Position
		 */
		$this->add_control(
			'position',
			array(
				'label'       => _x( 'Position', 'Elementor Widget', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => _x( 'Edit position...', 'Elementor Widget', 'arrigo' ),
			)
		);

		/**
		 * Social Heading
		 */
		$this->add_control(
			'social_heading',
			array(
				'label'     => _x( 'Social Media', 'Elementor Widget', 'arrigo' ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			)
		);

		$repeater = new \Elementor\Repeater();

		/**
		 * Social Link
		 */
		$repeater->add_control(
			'social_link',
			array(
				'label'         => _x( 'Link', 'Elementor Widget', 'arrigo' ),
				'type'          => \Elementor\Controls_Manager::URL,
				'placeholder'   => _x( 'https://...', 'Elementor Widget', 'arrigo' ),
				'show_external' => true,
				'default'       => array(
					'is_external' => true,
					'nofollow'    => true,
				),
			)
		);

		/**
		 * Social Icon
		 */
		$repeater->add_control(
			'social_icon',
			array(
				'label' => _x( 'Icon', 'Elementor Widget', 'arrigo' ),
				'type'  => \Elementor\Controls_Manager::ICON,
			)
		);

		/**
		 * Social Repeater Control
		 */
		$this->add_control(
			'social',
			array(
				'type'          => \Elementor\Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ social_icon.replace("fa fa-", "") }}}',
				'prevent_empty' => false,
			)
		);

		$this->end_controls_section();

		/**
		 * Section Avatar
		 */
		$this->start_controls_section(
			'avatar_section',
			array(
				'label' => _x( 'Avatar', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		/**
		 * Avatar
		 */
		$this->add_control(
			'avatar',
			array(
				'label'   => _x( 'Choose Image', 'Elementor Widget', 'arrigo' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => array(
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				),
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'name' );
		$this->add_inline_editing_attributes( 'position' );

		$this->add_render_attribute( 'item', 'class', 'figure-member' );

		if ( $settings['social'] ) {
			$this->add_render_attribute( 'item', 'class', 'figure-member_has-social' );
		}
		?>
			<div <?php $this->print_render_attribute_string( 'item' ); ?>>
				<?php if ( ! empty( $settings['avatar']['id'] ) ) : ?>
					<div class="figure-member__avatar">
						<?php
							arr_the_lazy_image(
								array(
									'id'    => $settings['avatar']['id'],
									'type'  => 'image',
									'class' => array(
										'wrapper' => array( 'position-relative' ),
										'image'   => array(),
									),
								)
							);
						?>
					</div>
				<?php endif; ?>
				<?php if ( ! empty( $settings['name'] ) || ! empty( $settings['position'] ) || ! empty( $settings['social'] ) ) : ?>
					<div class="figure-member__headline"></div>
					<div class="figure-member__footer">
						<?php if ( ! empty( $settings['name'] ) ) : ?>
							<h3 <?php $this->print_render_attribute_string( 'name' ); ?>><?php echo $settings['name']; ?></h3>
						<?php endif; ?>
						<?php if ( ! empty( $settings['position'] ) ) : ?>
							<div class="figure-member__position">
								<span <?php $this->print_render_attribute_string( 'position' ); ?>><?php echo $settings['position']; ?></span>
							</div>
						<?php endif; ?>
						<?php if ( $settings['social'] ) : ?>
							<div class="figure-member__social">
								<ul class="social">
									<?php foreach ( $settings['social'] as $item ) : ?>
										<li class="social__item">
											<?php
												$target   = $item['social_link']['is_external'] ? ' target="_blank"' : '';
												$nofollow = $item['social_link']['nofollow'] ? ' rel="nofollow"' : '';
											?>
											<a class="<?php echo $item['social_icon']; ?>" href="<?php echo $item['social_link']['url']; ?>" <?php echo $target . ' ' . $nofollow; ?>>
												<svg viewBox="0 0 152 152" version="1.1"
													xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
													<g fill="none" fill-rule="evenodd">
														<g transform="translate(-134.000000, -98.000000)">
															<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
														</g>
													</g>
												</svg>
											</a>
										</li>
									<?php endforeach; ?>
								</ul>
							</div>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>
		<?php
	}

	protected function content_template() {
		?>
			<#
				view.addInlineEditingAttributes( 'name' );
				view.addInlineEditingAttributes( 'position' );

				view.addRenderAttribute( 'item', 'class', 'figure-member' );

				if ( settings.social.length ) {
					view.addRenderAttribute( 'item', 'class', 'figure-member_has-social' );
				}
			#>
			<div {{{ view.getRenderAttributeString( 'item' ) }}}>
				<# if (settings.avatar) { #>
					<div class="figure-member__avatar">
						<img src="{{{ settings.avatar.url }}}" alt="" />
					</div>
				<# } #>
				<# if (settings.name || settings.position || settings.social.length) { #>
					<div class="figure-member__headline"></div>
					<div class="figure-member__footer">
						<# if (settings.name) { #>
							<h3 {{{ view.getRenderAttributeString( 'name' ) }}}>{{{ settings.name }}}</h3>
						<# } #>
						<# if (settings.position) { #>
							<div class="figure-member__position">
								<span {{{ view.getRenderAttributeString( 'position' ) }}}>{{{ settings.position }}}</span>
							</div>
						<# } #>
						<# if (settings.social.length) { #>
							<div class="figure-member__social">
								<ul class="social">
									<# _.each( settings.social, function(item) { #>
										<li class="social__item">
											<#
												var target = item.social_link.is_external ? ' target="_blank"' : '';
												var nofollow = item.social_link.nofollow ? ' rel="nofollow"' : '';
											#>
											<a class="{{{ item.social_icon }}}" href="{{{ item.social_link.url }}}" {{{ target }}} {{{ nofollow }}}>
												<svg viewBox="0 0 152 152" version="1.1"
													xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
													<g fill="none" fill-rule="evenodd">
														<g transform="translate(-134.000000, -98.000000)">
															<path class="circle" d="M135,174a75,75 0 1,0 150,0a75,75 0 1,0 -150,0"></path>
														</g>
													</g>
												</svg>
											</a>
										</li>
									<# }); #>
								</ul>
							</div>
						<# } #>
					</div>
				<# } #>
			</div>
		<?php
	}
}
