<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Arrigo_Elementor_Project_Properties_Widget extends Arr_Widget_Base {
	protected static $_instance;

	public function get_name() {
		return 'arrigo-widget-project-properties';
	}

	public function get_title() {
		return _x( 'Project Properties', 'Elementor Widget Title', 'arrigo' );
	}

	public function get_icon() {
		return 'eicon-plug';
	}

	public function get_categories() {
		return array( 'arrigo-static' );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$name  = $this->get_name();
		$title = $this->get_title();

		$widgets[ $name ] = array(
			'conditions'        => array( 'widgetType' => $name ),
			'fields'            => array(),
			'integration-class' => 'WPML_Arrigo_Elementor_Project_Properties_Widget',
		);

		return $widgets;
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', array( $this, 'wpml_widgets_to_translate_filter' ) );
	}

	protected function register_controls() {
		/**
		 * Section Content
		 */
		$this->start_controls_section(
			'content_section',
			array(
				'label' => _x( 'Content', 'Elementor Widget Section', 'arrigo' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new \Elementor\Repeater();

		/**
		 * Option
		 */
		$repeater->add_control(
			'option',
			array(
				'label'       => _x( 'Option', 'Elementor Widget Section', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
			)
		);

		/**
		 * Value
		 */
		$repeater->add_control(
			'value',
			array(
				'label'       => _x( 'Value', 'Elementor Widget Section', 'arrigo' ),
				'label_block' => true,
				'type'        => \Elementor\Controls_Manager::TEXT,
			)
		);

		/**
		 * Properties Repeater Control
		 */
		$this->add_control(
			'properties',
			array(
				'type'          => \Elementor\Controls_Manager::REPEATER,
				'fields'        => $repeater->get_controls(),
				'title_field'   => '{{{ option || value }}}',
				'prevent_empty' => false,
			)
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
		<?php if ( ! empty( $settings['properties'] ) ) : ?>
			<div class="portfolio-details__options">
				<div class="container">
					<div class="row">
						<?php foreach ( $settings['properties'] as $index => $item ) : ?>
							<?php
								$keyOption = $this->get_repeater_setting_key( 'option', 'properties', $index );
								$keyValue  = $this->get_repeater_setting_key( 'value', 'properties', $index );
								$this->add_inline_editing_attributes( $keyOption );
								$this->add_inline_editing_attributes( $keyValue );
							?>
							<div class="col-lg-3 col-sm-6 portfolio-details__option">
								<div class="figure-info">
									<div class="figure-info__option">
										<span <?php $this->print_render_attribute_string( $keyOption ); ?>><?php echo $item['option']; ?></span>
									</div>
									<div class="figure-info__value">
										<span <?php $this->print_render_attribute_string( $keyValue ); ?>><?php echo $item['value']; ?></span>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		<?php endif; ?>
		<?php
	}

	protected function content_template() {
		?>
		<# if (settings.properties.length ) { #>
			<div class="portfolio-details__options">
				<div class="container">
					<div class="row">
						<# _.each( settings.properties, function(item, index) { #>
							<#
								var keyOption = view.getRepeaterSettingKey( 'option', 'properties', index );
								var keyValue = view.getRepeaterSettingKey( 'value', 'properties', index );
								view.addInlineEditingAttributes( keyOption );
								view.addInlineEditingAttributes( keyValue );
							#>
							<div class="col-lg-3 col-sm-6 portfolio-details__option">
								<div class="figure-info">
									<div class="figure-info__option">
										<span {{{ view.getRenderAttributeString( keyOption ) }}}>{{{ item.option }}}</span>
									</div>
									<div class="figure-info__value">
										<span {{{ view.getRenderAttributeString( keyValue ) }}}>{{{ item.value }}}</span>
									</div>
								</div>
							</div>
						<# }); #>
					</div>
				</div>
			</div>
		<# } #>
		<?php
	}
}
